/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.transform.EcrConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EcrConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String repositoryName;
    private List<String> containerTags;

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public EcrConfiguration withRepositoryName(String repositoryName) {
        this.setRepositoryName(repositoryName);
        return this;
    }

    public List<String> getContainerTags() {
        return this.containerTags;
    }

    public void setContainerTags(Collection<String> containerTags) {
        if (containerTags == null) {
            this.containerTags = null;
            return;
        }
        this.containerTags = new ArrayList<String>(containerTags);
    }

    public EcrConfiguration withContainerTags(String ... containerTags) {
        if (this.containerTags == null) {
            this.setContainerTags(new ArrayList<String>(containerTags.length));
        }
        for (String ele : containerTags) {
            this.containerTags.add(ele);
        }
        return this;
    }

    public EcrConfiguration withContainerTags(Collection<String> containerTags) {
        this.setContainerTags(containerTags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepositoryName() != null) {
            sb.append("RepositoryName: ").append(this.getRepositoryName()).append(",");
        }
        if (this.getContainerTags() != null) {
            sb.append("ContainerTags: ").append(this.getContainerTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcrConfiguration)) {
            return false;
        }
        EcrConfiguration other = (EcrConfiguration)obj;
        if (other.getRepositoryName() == null ^ this.getRepositoryName() == null) {
            return false;
        }
        if (other.getRepositoryName() != null && !other.getRepositoryName().equals(this.getRepositoryName())) {
            return false;
        }
        if (other.getContainerTags() == null ^ this.getContainerTags() == null) {
            return false;
        }
        return other.getContainerTags() == null || other.getContainerTags().equals(this.getContainerTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepositoryName() == null ? 0 : this.getRepositoryName().hashCode());
        hashCode = 31 * hashCode + (this.getContainerTags() == null ? 0 : this.getContainerTags().hashCode());
        return hashCode;
    }

    public EcrConfiguration clone() {
        try {
            return (EcrConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcrConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

