/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.transform.ContainerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Container
implements Serializable,
Cloneable,
StructuredPojo {
    private String region;
    private List<String> imageUris;

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public Container withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public List<String> getImageUris() {
        return this.imageUris;
    }

    public void setImageUris(Collection<String> imageUris) {
        if (imageUris == null) {
            this.imageUris = null;
            return;
        }
        this.imageUris = new ArrayList<String>(imageUris);
    }

    public Container withImageUris(String ... imageUris) {
        if (this.imageUris == null) {
            this.setImageUris(new ArrayList<String>(imageUris.length));
        }
        for (String ele : imageUris) {
            this.imageUris.add(ele);
        }
        return this;
    }

    public Container withImageUris(Collection<String> imageUris) {
        this.setImageUris(imageUris);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getImageUris() != null) {
            sb.append("ImageUris: ").append(this.getImageUris());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getImageUris() == null ^ this.getImageUris() == null) {
            return false;
        }
        return other.getImageUris() == null || other.getImageUris().equals(this.getImageUris());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getImageUris() == null ? 0 : this.getImageUris().hashCode());
        return hashCode;
    }

    public Container clone() {
        try {
            return (Container)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

