/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.fms.model.ResourceSet;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ResourceSetMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> UPDATETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateToken").build();
    private static final MarshallingInfo<List> RESOURCETYPELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceTypeList").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RESOURCESETSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceSetStatus").build();
    private static final ResourceSetMarshaller instance = new ResourceSetMarshaller();

    public static ResourceSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceSet resourceSet, ProtocolMarshaller protocolMarshaller) {
        if (resourceSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceSet.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)resourceSet.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)resourceSet.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)resourceSet.getUpdateToken(), UPDATETOKEN_BINDING);
            protocolMarshaller.marshall(resourceSet.getResourceTypeList(), RESOURCETYPELIST_BINDING);
            protocolMarshaller.marshall((Object)resourceSet.getLastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)resourceSet.getResourceSetStatus(), RESOURCESETSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

