/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.NetworkAclEntry;

@SdkInternalApi
public class NetworkAclEntryMarshaller {
    private static final MarshallingInfo<StructuredPojo> ICMPTYPECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IcmpTypeCode").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Protocol").build();
    private static final MarshallingInfo<StructuredPojo> PORTRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PortRange").build();
    private static final MarshallingInfo<String> CIDRBLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CidrBlock").build();
    private static final MarshallingInfo<String> IPV6CIDRBLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ipv6CidrBlock").build();
    private static final MarshallingInfo<String> RULEACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleAction").build();
    private static final MarshallingInfo<Boolean> EGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Egress").build();
    private static final NetworkAclEntryMarshaller instance = new NetworkAclEntryMarshaller();

    public static NetworkAclEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkAclEntry networkAclEntry, ProtocolMarshaller protocolMarshaller) {
        if (networkAclEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)networkAclEntry.getIcmpTypeCode(), ICMPTYPECODE_BINDING);
            protocolMarshaller.marshall((Object)networkAclEntry.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)networkAclEntry.getPortRange(), PORTRANGE_BINDING);
            protocolMarshaller.marshall((Object)networkAclEntry.getCidrBlock(), CIDRBLOCK_BINDING);
            protocolMarshaller.marshall((Object)networkAclEntry.getIpv6CidrBlock(), IPV6CIDRBLOCK_BINDING);
            protocolMarshaller.marshall((Object)networkAclEntry.getRuleAction(), RULEACTION_BINDING);
            protocolMarshaller.marshall((Object)networkAclEntry.getEgress(), EGRESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

