/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.eks.model.EncryptionConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssociateEncryptionConfigRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterName;
    private List<EncryptionConfig> encryptionConfig;
    private String clientRequestToken;

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public AssociateEncryptionConfigRequest withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public List<EncryptionConfig> getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public void setEncryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
        if (encryptionConfig == null) {
            this.encryptionConfig = null;
            return;
        }
        this.encryptionConfig = new ArrayList<EncryptionConfig>(encryptionConfig);
    }

    public AssociateEncryptionConfigRequest withEncryptionConfig(EncryptionConfig ... encryptionConfig) {
        if (this.encryptionConfig == null) {
            this.setEncryptionConfig(new ArrayList<EncryptionConfig>(encryptionConfig.length));
        }
        for (EncryptionConfig ele : encryptionConfig) {
            this.encryptionConfig.add(ele);
        }
        return this;
    }

    public AssociateEncryptionConfigRequest withEncryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
        this.setEncryptionConfig(encryptionConfig);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public AssociateEncryptionConfigRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getEncryptionConfig() != null) {
            sb.append("EncryptionConfig: ").append(this.getEncryptionConfig()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEncryptionConfigRequest)) {
            return false;
        }
        AssociateEncryptionConfigRequest other = (AssociateEncryptionConfigRequest)obj;
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getEncryptionConfig() == null ^ this.getEncryptionConfig() == null) {
            return false;
        }
        if (other.getEncryptionConfig() != null && !other.getEncryptionConfig().equals(this.getEncryptionConfig())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        return other.getClientRequestToken() == null || other.getClientRequestToken().equals(this.getClientRequestToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfig() == null ? 0 : this.getEncryptionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        return hashCode;
    }

    public AssociateEncryptionConfigRequest clone() {
        return (AssociateEncryptionConfigRequest)super.clone();
    }
}

