/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecrpublic;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ecrpublic.AmazonECRPublicAsync;
import com.amazonaws.services.ecrpublic.AmazonECRPublicAsyncClientBuilder;
import com.amazonaws.services.ecrpublic.AmazonECRPublicClient;
import com.amazonaws.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.services.ecrpublic.model.BatchCheckLayerAvailabilityResult;
import com.amazonaws.services.ecrpublic.model.BatchDeleteImageRequest;
import com.amazonaws.services.ecrpublic.model.BatchDeleteImageResult;
import com.amazonaws.services.ecrpublic.model.CompleteLayerUploadRequest;
import com.amazonaws.services.ecrpublic.model.CompleteLayerUploadResult;
import com.amazonaws.services.ecrpublic.model.CreateRepositoryRequest;
import com.amazonaws.services.ecrpublic.model.CreateRepositoryResult;
import com.amazonaws.services.ecrpublic.model.DeleteRepositoryPolicyRequest;
import com.amazonaws.services.ecrpublic.model.DeleteRepositoryPolicyResult;
import com.amazonaws.services.ecrpublic.model.DeleteRepositoryRequest;
import com.amazonaws.services.ecrpublic.model.DeleteRepositoryResult;
import com.amazonaws.services.ecrpublic.model.DescribeImageTagsRequest;
import com.amazonaws.services.ecrpublic.model.DescribeImageTagsResult;
import com.amazonaws.services.ecrpublic.model.DescribeImagesRequest;
import com.amazonaws.services.ecrpublic.model.DescribeImagesResult;
import com.amazonaws.services.ecrpublic.model.DescribeRegistriesRequest;
import com.amazonaws.services.ecrpublic.model.DescribeRegistriesResult;
import com.amazonaws.services.ecrpublic.model.DescribeRepositoriesRequest;
import com.amazonaws.services.ecrpublic.model.DescribeRepositoriesResult;
import com.amazonaws.services.ecrpublic.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecrpublic.model.GetAuthorizationTokenResult;
import com.amazonaws.services.ecrpublic.model.GetRegistryCatalogDataRequest;
import com.amazonaws.services.ecrpublic.model.GetRegistryCatalogDataResult;
import com.amazonaws.services.ecrpublic.model.GetRepositoryCatalogDataRequest;
import com.amazonaws.services.ecrpublic.model.GetRepositoryCatalogDataResult;
import com.amazonaws.services.ecrpublic.model.GetRepositoryPolicyRequest;
import com.amazonaws.services.ecrpublic.model.GetRepositoryPolicyResult;
import com.amazonaws.services.ecrpublic.model.InitiateLayerUploadRequest;
import com.amazonaws.services.ecrpublic.model.InitiateLayerUploadResult;
import com.amazonaws.services.ecrpublic.model.ListTagsForResourceRequest;
import com.amazonaws.services.ecrpublic.model.ListTagsForResourceResult;
import com.amazonaws.services.ecrpublic.model.PutImageRequest;
import com.amazonaws.services.ecrpublic.model.PutImageResult;
import com.amazonaws.services.ecrpublic.model.PutRegistryCatalogDataRequest;
import com.amazonaws.services.ecrpublic.model.PutRegistryCatalogDataResult;
import com.amazonaws.services.ecrpublic.model.PutRepositoryCatalogDataRequest;
import com.amazonaws.services.ecrpublic.model.PutRepositoryCatalogDataResult;
import com.amazonaws.services.ecrpublic.model.SetRepositoryPolicyRequest;
import com.amazonaws.services.ecrpublic.model.SetRepositoryPolicyResult;
import com.amazonaws.services.ecrpublic.model.TagResourceRequest;
import com.amazonaws.services.ecrpublic.model.TagResourceResult;
import com.amazonaws.services.ecrpublic.model.UntagResourceRequest;
import com.amazonaws.services.ecrpublic.model.UntagResourceResult;
import com.amazonaws.services.ecrpublic.model.UploadLayerPartRequest;
import com.amazonaws.services.ecrpublic.model.UploadLayerPartResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonECRPublicAsyncClient
extends AmazonECRPublicClient
implements AmazonECRPublicAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonECRPublicAsyncClientBuilder asyncBuilder() {
        return AmazonECRPublicAsyncClientBuilder.standard();
    }

    AmazonECRPublicAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonECRPublicAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchCheckLayerAvailabilityResult> batchCheckLayerAvailabilityAsync(BatchCheckLayerAvailabilityRequest request) {
        return this.batchCheckLayerAvailabilityAsync(request, null);
    }

    @Override
    public Future<BatchCheckLayerAvailabilityResult> batchCheckLayerAvailabilityAsync(BatchCheckLayerAvailabilityRequest request, final AsyncHandler<BatchCheckLayerAvailabilityRequest, BatchCheckLayerAvailabilityResult> asyncHandler) {
        final BatchCheckLayerAvailabilityRequest finalRequest = (BatchCheckLayerAvailabilityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchCheckLayerAvailabilityResult>(){

            @Override
            public BatchCheckLayerAvailabilityResult call() throws Exception {
                BatchCheckLayerAvailabilityResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeBatchCheckLayerAvailability(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDeleteImageResult> batchDeleteImageAsync(BatchDeleteImageRequest request) {
        return this.batchDeleteImageAsync(request, null);
    }

    @Override
    public Future<BatchDeleteImageResult> batchDeleteImageAsync(BatchDeleteImageRequest request, final AsyncHandler<BatchDeleteImageRequest, BatchDeleteImageResult> asyncHandler) {
        final BatchDeleteImageRequest finalRequest = (BatchDeleteImageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDeleteImageResult>(){

            @Override
            public BatchDeleteImageResult call() throws Exception {
                BatchDeleteImageResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeBatchDeleteImage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CompleteLayerUploadResult> completeLayerUploadAsync(CompleteLayerUploadRequest request) {
        return this.completeLayerUploadAsync(request, null);
    }

    @Override
    public Future<CompleteLayerUploadResult> completeLayerUploadAsync(CompleteLayerUploadRequest request, final AsyncHandler<CompleteLayerUploadRequest, CompleteLayerUploadResult> asyncHandler) {
        final CompleteLayerUploadRequest finalRequest = (CompleteLayerUploadRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CompleteLayerUploadResult>(){

            @Override
            public CompleteLayerUploadResult call() throws Exception {
                CompleteLayerUploadResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeCompleteLayerUpload(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryAsync(request, null);
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(CreateRepositoryRequest request, final AsyncHandler<CreateRepositoryRequest, CreateRepositoryResult> asyncHandler) {
        final CreateRepositoryRequest finalRequest = (CreateRepositoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRepositoryResult>(){

            @Override
            public CreateRepositoryResult call() throws Exception {
                CreateRepositoryResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeCreateRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(DeleteRepositoryRequest request, final AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResult> asyncHandler) {
        final DeleteRepositoryRequest finalRequest = (DeleteRepositoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRepositoryResult>(){

            @Override
            public DeleteRepositoryResult call() throws Exception {
                DeleteRepositoryResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeDeleteRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryPolicyResult> deleteRepositoryPolicyAsync(DeleteRepositoryPolicyRequest request) {
        return this.deleteRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryPolicyResult> deleteRepositoryPolicyAsync(DeleteRepositoryPolicyRequest request, final AsyncHandler<DeleteRepositoryPolicyRequest, DeleteRepositoryPolicyResult> asyncHandler) {
        final DeleteRepositoryPolicyRequest finalRequest = (DeleteRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRepositoryPolicyResult>(){

            @Override
            public DeleteRepositoryPolicyResult call() throws Exception {
                DeleteRepositoryPolicyResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeDeleteRepositoryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImageTagsResult> describeImageTagsAsync(DescribeImageTagsRequest request) {
        return this.describeImageTagsAsync(request, null);
    }

    @Override
    public Future<DescribeImageTagsResult> describeImageTagsAsync(DescribeImageTagsRequest request, final AsyncHandler<DescribeImageTagsRequest, DescribeImageTagsResult> asyncHandler) {
        final DescribeImageTagsRequest finalRequest = (DescribeImageTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeImageTagsResult>(){

            @Override
            public DescribeImageTagsResult call() throws Exception {
                DescribeImageTagsResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeDescribeImageTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(DescribeImagesRequest request) {
        return this.describeImagesAsync(request, null);
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(DescribeImagesRequest request, final AsyncHandler<DescribeImagesRequest, DescribeImagesResult> asyncHandler) {
        final DescribeImagesRequest finalRequest = (DescribeImagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeImagesResult>(){

            @Override
            public DescribeImagesResult call() throws Exception {
                DescribeImagesResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeDescribeImages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRegistriesResult> describeRegistriesAsync(DescribeRegistriesRequest request) {
        return this.describeRegistriesAsync(request, null);
    }

    @Override
    public Future<DescribeRegistriesResult> describeRegistriesAsync(DescribeRegistriesRequest request, final AsyncHandler<DescribeRegistriesRequest, DescribeRegistriesResult> asyncHandler) {
        final DescribeRegistriesRequest finalRequest = (DescribeRegistriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRegistriesResult>(){

            @Override
            public DescribeRegistriesResult call() throws Exception {
                DescribeRegistriesResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeDescribeRegistries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRepositoriesResult> describeRepositoriesAsync(DescribeRepositoriesRequest request) {
        return this.describeRepositoriesAsync(request, null);
    }

    @Override
    public Future<DescribeRepositoriesResult> describeRepositoriesAsync(DescribeRepositoriesRequest request, final AsyncHandler<DescribeRepositoriesRequest, DescribeRepositoriesResult> asyncHandler) {
        final DescribeRepositoriesRequest finalRequest = (DescribeRepositoriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRepositoriesResult>(){

            @Override
            public DescribeRepositoriesResult call() throws Exception {
                DescribeRepositoriesResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeDescribeRepositories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAuthorizationTokenResult> getAuthorizationTokenAsync(GetAuthorizationTokenRequest request) {
        return this.getAuthorizationTokenAsync(request, null);
    }

    @Override
    public Future<GetAuthorizationTokenResult> getAuthorizationTokenAsync(GetAuthorizationTokenRequest request, final AsyncHandler<GetAuthorizationTokenRequest, GetAuthorizationTokenResult> asyncHandler) {
        final GetAuthorizationTokenRequest finalRequest = (GetAuthorizationTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAuthorizationTokenResult>(){

            @Override
            public GetAuthorizationTokenResult call() throws Exception {
                GetAuthorizationTokenResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeGetAuthorizationToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRegistryCatalogDataResult> getRegistryCatalogDataAsync(GetRegistryCatalogDataRequest request) {
        return this.getRegistryCatalogDataAsync(request, null);
    }

    @Override
    public Future<GetRegistryCatalogDataResult> getRegistryCatalogDataAsync(GetRegistryCatalogDataRequest request, final AsyncHandler<GetRegistryCatalogDataRequest, GetRegistryCatalogDataResult> asyncHandler) {
        final GetRegistryCatalogDataRequest finalRequest = (GetRegistryCatalogDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRegistryCatalogDataResult>(){

            @Override
            public GetRegistryCatalogDataResult call() throws Exception {
                GetRegistryCatalogDataResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeGetRegistryCatalogData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryCatalogDataResult> getRepositoryCatalogDataAsync(GetRepositoryCatalogDataRequest request) {
        return this.getRepositoryCatalogDataAsync(request, null);
    }

    @Override
    public Future<GetRepositoryCatalogDataResult> getRepositoryCatalogDataAsync(GetRepositoryCatalogDataRequest request, final AsyncHandler<GetRepositoryCatalogDataRequest, GetRepositoryCatalogDataResult> asyncHandler) {
        final GetRepositoryCatalogDataRequest finalRequest = (GetRepositoryCatalogDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRepositoryCatalogDataResult>(){

            @Override
            public GetRepositoryCatalogDataResult call() throws Exception {
                GetRepositoryCatalogDataResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeGetRepositoryCatalogData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryPolicyResult> getRepositoryPolicyAsync(GetRepositoryPolicyRequest request) {
        return this.getRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<GetRepositoryPolicyResult> getRepositoryPolicyAsync(GetRepositoryPolicyRequest request, final AsyncHandler<GetRepositoryPolicyRequest, GetRepositoryPolicyResult> asyncHandler) {
        final GetRepositoryPolicyRequest finalRequest = (GetRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRepositoryPolicyResult>(){

            @Override
            public GetRepositoryPolicyResult call() throws Exception {
                GetRepositoryPolicyResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeGetRepositoryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateLayerUploadResult> initiateLayerUploadAsync(InitiateLayerUploadRequest request) {
        return this.initiateLayerUploadAsync(request, null);
    }

    @Override
    public Future<InitiateLayerUploadResult> initiateLayerUploadAsync(InitiateLayerUploadRequest request, final AsyncHandler<InitiateLayerUploadRequest, InitiateLayerUploadResult> asyncHandler) {
        final InitiateLayerUploadRequest finalRequest = (InitiateLayerUploadRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InitiateLayerUploadResult>(){

            @Override
            public InitiateLayerUploadResult call() throws Exception {
                InitiateLayerUploadResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeInitiateLayerUpload(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutImageResult> putImageAsync(PutImageRequest request) {
        return this.putImageAsync(request, null);
    }

    @Override
    public Future<PutImageResult> putImageAsync(PutImageRequest request, final AsyncHandler<PutImageRequest, PutImageResult> asyncHandler) {
        final PutImageRequest finalRequest = (PutImageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutImageResult>(){

            @Override
            public PutImageResult call() throws Exception {
                PutImageResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executePutImage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRegistryCatalogDataResult> putRegistryCatalogDataAsync(PutRegistryCatalogDataRequest request) {
        return this.putRegistryCatalogDataAsync(request, null);
    }

    @Override
    public Future<PutRegistryCatalogDataResult> putRegistryCatalogDataAsync(PutRegistryCatalogDataRequest request, final AsyncHandler<PutRegistryCatalogDataRequest, PutRegistryCatalogDataResult> asyncHandler) {
        final PutRegistryCatalogDataRequest finalRequest = (PutRegistryCatalogDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRegistryCatalogDataResult>(){

            @Override
            public PutRegistryCatalogDataResult call() throws Exception {
                PutRegistryCatalogDataResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executePutRegistryCatalogData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRepositoryCatalogDataResult> putRepositoryCatalogDataAsync(PutRepositoryCatalogDataRequest request) {
        return this.putRepositoryCatalogDataAsync(request, null);
    }

    @Override
    public Future<PutRepositoryCatalogDataResult> putRepositoryCatalogDataAsync(PutRepositoryCatalogDataRequest request, final AsyncHandler<PutRepositoryCatalogDataRequest, PutRepositoryCatalogDataResult> asyncHandler) {
        final PutRepositoryCatalogDataRequest finalRequest = (PutRepositoryCatalogDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRepositoryCatalogDataResult>(){

            @Override
            public PutRepositoryCatalogDataResult call() throws Exception {
                PutRepositoryCatalogDataResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executePutRepositoryCatalogData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetRepositoryPolicyResult> setRepositoryPolicyAsync(SetRepositoryPolicyRequest request) {
        return this.setRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<SetRepositoryPolicyResult> setRepositoryPolicyAsync(SetRepositoryPolicyRequest request, final AsyncHandler<SetRepositoryPolicyRequest, SetRepositoryPolicyResult> asyncHandler) {
        final SetRepositoryPolicyRequest finalRequest = (SetRepositoryPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetRepositoryPolicyResult>(){

            @Override
            public SetRepositoryPolicyResult call() throws Exception {
                SetRepositoryPolicyResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeSetRepositoryPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UploadLayerPartResult> uploadLayerPartAsync(UploadLayerPartRequest request) {
        return this.uploadLayerPartAsync(request, null);
    }

    @Override
    public Future<UploadLayerPartResult> uploadLayerPartAsync(UploadLayerPartRequest request, final AsyncHandler<UploadLayerPartRequest, UploadLayerPartResult> asyncHandler) {
        final UploadLayerPartRequest finalRequest = (UploadLayerPartRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UploadLayerPartResult>(){

            @Override
            public UploadLayerPartResult call() throws Exception {
                UploadLayerPartResult result = null;
                try {
                    result = AmazonECRPublicAsyncClient.this.executeUploadLayerPart(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

