/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codepipeline.model.PipelineVariable;
import com.amazonaws.services.codepipeline.model.SourceRevisionOverride;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartPipelineExecutionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private List<PipelineVariable> variables;
    private String clientRequestToken;
    private List<SourceRevisionOverride> sourceRevisions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public StartPipelineExecutionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<PipelineVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<PipelineVariable> variables) {
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new ArrayList<PipelineVariable>(variables);
    }

    public StartPipelineExecutionRequest withVariables(PipelineVariable ... variables) {
        if (this.variables == null) {
            this.setVariables(new ArrayList<PipelineVariable>(variables.length));
        }
        for (PipelineVariable ele : variables) {
            this.variables.add(ele);
        }
        return this;
    }

    public StartPipelineExecutionRequest withVariables(Collection<PipelineVariable> variables) {
        this.setVariables(variables);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public StartPipelineExecutionRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public List<SourceRevisionOverride> getSourceRevisions() {
        return this.sourceRevisions;
    }

    public void setSourceRevisions(Collection<SourceRevisionOverride> sourceRevisions) {
        if (sourceRevisions == null) {
            this.sourceRevisions = null;
            return;
        }
        this.sourceRevisions = new ArrayList<SourceRevisionOverride>(sourceRevisions);
    }

    public StartPipelineExecutionRequest withSourceRevisions(SourceRevisionOverride ... sourceRevisions) {
        if (this.sourceRevisions == null) {
            this.setSourceRevisions(new ArrayList<SourceRevisionOverride>(sourceRevisions.length));
        }
        for (SourceRevisionOverride ele : sourceRevisions) {
            this.sourceRevisions.add(ele);
        }
        return this;
    }

    public StartPipelineExecutionRequest withSourceRevisions(Collection<SourceRevisionOverride> sourceRevisions) {
        this.setSourceRevisions(sourceRevisions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getSourceRevisions() != null) {
            sb.append("SourceRevisions: ").append(this.getSourceRevisions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPipelineExecutionRequest)) {
            return false;
        }
        StartPipelineExecutionRequest other = (StartPipelineExecutionRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        if (other.getVariables() != null && !other.getVariables().equals(this.getVariables())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getSourceRevisions() == null ^ this.getSourceRevisions() == null) {
            return false;
        }
        return other.getSourceRevisions() == null || other.getSourceRevisions().equals(this.getSourceRevisions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getSourceRevisions() == null ? 0 : this.getSourceRevisions().hashCode());
        return hashCode;
    }

    public StartPipelineExecutionRequest clone() {
        return (StartPipelineExecutionRequest)super.clone();
    }
}

