/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.GitPullRequestFilter;
import com.amazonaws.services.codepipeline.model.GitPushFilter;
import com.amazonaws.services.codepipeline.model.transform.GitConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GitConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String sourceActionName;
    private List<GitPushFilter> push;
    private List<GitPullRequestFilter> pullRequest;

    public void setSourceActionName(String sourceActionName) {
        this.sourceActionName = sourceActionName;
    }

    public String getSourceActionName() {
        return this.sourceActionName;
    }

    public GitConfiguration withSourceActionName(String sourceActionName) {
        this.setSourceActionName(sourceActionName);
        return this;
    }

    public List<GitPushFilter> getPush() {
        return this.push;
    }

    public void setPush(Collection<GitPushFilter> push) {
        if (push == null) {
            this.push = null;
            return;
        }
        this.push = new ArrayList<GitPushFilter>(push);
    }

    public GitConfiguration withPush(GitPushFilter ... push) {
        if (this.push == null) {
            this.setPush(new ArrayList<GitPushFilter>(push.length));
        }
        for (GitPushFilter ele : push) {
            this.push.add(ele);
        }
        return this;
    }

    public GitConfiguration withPush(Collection<GitPushFilter> push) {
        this.setPush(push);
        return this;
    }

    public List<GitPullRequestFilter> getPullRequest() {
        return this.pullRequest;
    }

    public void setPullRequest(Collection<GitPullRequestFilter> pullRequest) {
        if (pullRequest == null) {
            this.pullRequest = null;
            return;
        }
        this.pullRequest = new ArrayList<GitPullRequestFilter>(pullRequest);
    }

    public GitConfiguration withPullRequest(GitPullRequestFilter ... pullRequest) {
        if (this.pullRequest == null) {
            this.setPullRequest(new ArrayList<GitPullRequestFilter>(pullRequest.length));
        }
        for (GitPullRequestFilter ele : pullRequest) {
            this.pullRequest.add(ele);
        }
        return this;
    }

    public GitConfiguration withPullRequest(Collection<GitPullRequestFilter> pullRequest) {
        this.setPullRequest(pullRequest);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceActionName() != null) {
            sb.append("SourceActionName: ").append(this.getSourceActionName()).append(",");
        }
        if (this.getPush() != null) {
            sb.append("Push: ").append(this.getPush()).append(",");
        }
        if (this.getPullRequest() != null) {
            sb.append("PullRequest: ").append(this.getPullRequest());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitConfiguration)) {
            return false;
        }
        GitConfiguration other = (GitConfiguration)obj;
        if (other.getSourceActionName() == null ^ this.getSourceActionName() == null) {
            return false;
        }
        if (other.getSourceActionName() != null && !other.getSourceActionName().equals(this.getSourceActionName())) {
            return false;
        }
        if (other.getPush() == null ^ this.getPush() == null) {
            return false;
        }
        if (other.getPush() != null && !other.getPush().equals(this.getPush())) {
            return false;
        }
        if (other.getPullRequest() == null ^ this.getPullRequest() == null) {
            return false;
        }
        return other.getPullRequest() == null || other.getPullRequest().equals(this.getPullRequest());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceActionName() == null ? 0 : this.getSourceActionName().hashCode());
        hashCode = 31 * hashCode + (this.getPush() == null ? 0 : this.getPush().hashCode());
        hashCode = 31 * hashCode + (this.getPullRequest() == null ? 0 : this.getPullRequest().hashCode());
        return hashCode;
    }

    public GitConfiguration clone() {
        try {
            return (GitConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GitConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

