/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.b2bi.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformerJob" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetTransformerJobResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     * <code>failed</code>.
     * </p>
     */
    private String status;
    /**
     * <p>
     * Returns the location for the output files. If the caller specified a directory for the output, then this contains
     * the full path to the output file, including the file name generated by the service.
     * </p>
     */
    private java.util.List<S3Location> outputFiles;
    /**
     * <p>
     * Returns an optional error message, which gets populated when the job is not run successfully.
     * </p>
     */
    private String message;

    /**
     * <p>
     * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     * <code>failed</code>.
     * </p>
     * 
     * @param status
     *        Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     *        <code>failed</code>.
     * @see TransformerJobStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     * <code>failed</code>.
     * </p>
     * 
     * @return Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     *         <code>failed</code>.
     * @see TransformerJobStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     * <code>failed</code>.
     * </p>
     * 
     * @param status
     *        Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     *        <code>failed</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransformerJobStatus
     */

    public GetTransformerJobResult withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     * <code>failed</code>.
     * </p>
     * 
     * @param status
     *        Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or
     *        <code>failed</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransformerJobStatus
     */

    public GetTransformerJobResult withStatus(TransformerJobStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * Returns the location for the output files. If the caller specified a directory for the output, then this contains
     * the full path to the output file, including the file name generated by the service.
     * </p>
     * 
     * @return Returns the location for the output files. If the caller specified a directory for the output, then this
     *         contains the full path to the output file, including the file name generated by the service.
     */

    public java.util.List<S3Location> getOutputFiles() {
        return outputFiles;
    }

    /**
     * <p>
     * Returns the location for the output files. If the caller specified a directory for the output, then this contains
     * the full path to the output file, including the file name generated by the service.
     * </p>
     * 
     * @param outputFiles
     *        Returns the location for the output files. If the caller specified a directory for the output, then this
     *        contains the full path to the output file, including the file name generated by the service.
     */

    public void setOutputFiles(java.util.Collection<S3Location> outputFiles) {
        if (outputFiles == null) {
            this.outputFiles = null;
            return;
        }

        this.outputFiles = new java.util.ArrayList<S3Location>(outputFiles);
    }

    /**
     * <p>
     * Returns the location for the output files. If the caller specified a directory for the output, then this contains
     * the full path to the output file, including the file name generated by the service.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setOutputFiles(java.util.Collection)} or {@link #withOutputFiles(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param outputFiles
     *        Returns the location for the output files. If the caller specified a directory for the output, then this
     *        contains the full path to the output file, including the file name generated by the service.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetTransformerJobResult withOutputFiles(S3Location... outputFiles) {
        if (this.outputFiles == null) {
            setOutputFiles(new java.util.ArrayList<S3Location>(outputFiles.length));
        }
        for (S3Location ele : outputFiles) {
            this.outputFiles.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Returns the location for the output files. If the caller specified a directory for the output, then this contains
     * the full path to the output file, including the file name generated by the service.
     * </p>
     * 
     * @param outputFiles
     *        Returns the location for the output files. If the caller specified a directory for the output, then this
     *        contains the full path to the output file, including the file name generated by the service.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetTransformerJobResult withOutputFiles(java.util.Collection<S3Location> outputFiles) {
        setOutputFiles(outputFiles);
        return this;
    }

    /**
     * <p>
     * Returns an optional error message, which gets populated when the job is not run successfully.
     * </p>
     * 
     * @param message
     *        Returns an optional error message, which gets populated when the job is not run successfully.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * Returns an optional error message, which gets populated when the job is not run successfully.
     * </p>
     * 
     * @return Returns an optional error message, which gets populated when the job is not run successfully.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * Returns an optional error message, which gets populated when the job is not run successfully.
     * </p>
     * 
     * @param message
     *        Returns an optional error message, which gets populated when the job is not run successfully.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetTransformerJobResult withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getOutputFiles() != null)
            sb.append("OutputFiles: ").append(getOutputFiles()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetTransformerJobResult == false)
            return false;
        GetTransformerJobResult other = (GetTransformerJobResult) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getOutputFiles() == null ^ this.getOutputFiles() == null)
            return false;
        if (other.getOutputFiles() != null && other.getOutputFiles().equals(this.getOutputFiles()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getOutputFiles() == null) ? 0 : getOutputFiles().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        return hashCode;
    }

    @Override
    public GetTransformerJobResult clone() {
        try {
            return (GetTransformerJobResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
