/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appstream.model.AccessEndpoint;
import com.amazonaws.services.appstream.model.ApplicationSettings;
import com.amazonaws.services.appstream.model.StorageConnector;
import com.amazonaws.services.appstream.model.StreamingExperienceSettings;
import com.amazonaws.services.appstream.model.UserSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateStackRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String displayName;
    private List<StorageConnector> storageConnectors;
    private String redirectURL;
    private String feedbackURL;
    private List<UserSetting> userSettings;
    private ApplicationSettings applicationSettings;
    private Map<String, String> tags;
    private List<AccessEndpoint> accessEndpoints;
    private List<String> embedHostDomains;
    private StreamingExperienceSettings streamingExperienceSettings;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateStackRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateStackRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateStackRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public List<StorageConnector> getStorageConnectors() {
        return this.storageConnectors;
    }

    public void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
        if (storageConnectors == null) {
            this.storageConnectors = null;
            return;
        }
        this.storageConnectors = new ArrayList<StorageConnector>(storageConnectors);
    }

    public CreateStackRequest withStorageConnectors(StorageConnector ... storageConnectors) {
        if (this.storageConnectors == null) {
            this.setStorageConnectors(new ArrayList<StorageConnector>(storageConnectors.length));
        }
        for (StorageConnector ele : storageConnectors) {
            this.storageConnectors.add(ele);
        }
        return this;
    }

    public CreateStackRequest withStorageConnectors(Collection<StorageConnector> storageConnectors) {
        this.setStorageConnectors(storageConnectors);
        return this;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public CreateStackRequest withRedirectURL(String redirectURL) {
        this.setRedirectURL(redirectURL);
        return this;
    }

    public void setFeedbackURL(String feedbackURL) {
        this.feedbackURL = feedbackURL;
    }

    public String getFeedbackURL() {
        return this.feedbackURL;
    }

    public CreateStackRequest withFeedbackURL(String feedbackURL) {
        this.setFeedbackURL(feedbackURL);
        return this;
    }

    public List<UserSetting> getUserSettings() {
        return this.userSettings;
    }

    public void setUserSettings(Collection<UserSetting> userSettings) {
        if (userSettings == null) {
            this.userSettings = null;
            return;
        }
        this.userSettings = new ArrayList<UserSetting>(userSettings);
    }

    public CreateStackRequest withUserSettings(UserSetting ... userSettings) {
        if (this.userSettings == null) {
            this.setUserSettings(new ArrayList<UserSetting>(userSettings.length));
        }
        for (UserSetting ele : userSettings) {
            this.userSettings.add(ele);
        }
        return this;
    }

    public CreateStackRequest withUserSettings(Collection<UserSetting> userSettings) {
        this.setUserSettings(userSettings);
        return this;
    }

    public void setApplicationSettings(ApplicationSettings applicationSettings) {
        this.applicationSettings = applicationSettings;
    }

    public ApplicationSettings getApplicationSettings() {
        return this.applicationSettings;
    }

    public CreateStackRequest withApplicationSettings(ApplicationSettings applicationSettings) {
        this.setApplicationSettings(applicationSettings);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateStackRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateStackRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateStackRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<AccessEndpoint> getAccessEndpoints() {
        return this.accessEndpoints;
    }

    public void setAccessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
        if (accessEndpoints == null) {
            this.accessEndpoints = null;
            return;
        }
        this.accessEndpoints = new ArrayList<AccessEndpoint>(accessEndpoints);
    }

    public CreateStackRequest withAccessEndpoints(AccessEndpoint ... accessEndpoints) {
        if (this.accessEndpoints == null) {
            this.setAccessEndpoints(new ArrayList<AccessEndpoint>(accessEndpoints.length));
        }
        for (AccessEndpoint ele : accessEndpoints) {
            this.accessEndpoints.add(ele);
        }
        return this;
    }

    public CreateStackRequest withAccessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
        this.setAccessEndpoints(accessEndpoints);
        return this;
    }

    public List<String> getEmbedHostDomains() {
        return this.embedHostDomains;
    }

    public void setEmbedHostDomains(Collection<String> embedHostDomains) {
        if (embedHostDomains == null) {
            this.embedHostDomains = null;
            return;
        }
        this.embedHostDomains = new ArrayList<String>(embedHostDomains);
    }

    public CreateStackRequest withEmbedHostDomains(String ... embedHostDomains) {
        if (this.embedHostDomains == null) {
            this.setEmbedHostDomains(new ArrayList<String>(embedHostDomains.length));
        }
        for (String ele : embedHostDomains) {
            this.embedHostDomains.add(ele);
        }
        return this;
    }

    public CreateStackRequest withEmbedHostDomains(Collection<String> embedHostDomains) {
        this.setEmbedHostDomains(embedHostDomains);
        return this;
    }

    public void setStreamingExperienceSettings(StreamingExperienceSettings streamingExperienceSettings) {
        this.streamingExperienceSettings = streamingExperienceSettings;
    }

    public StreamingExperienceSettings getStreamingExperienceSettings() {
        return this.streamingExperienceSettings;
    }

    public CreateStackRequest withStreamingExperienceSettings(StreamingExperienceSettings streamingExperienceSettings) {
        this.setStreamingExperienceSettings(streamingExperienceSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getStorageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.getStorageConnectors()).append(",");
        }
        if (this.getRedirectURL() != null) {
            sb.append("RedirectURL: ").append(this.getRedirectURL()).append(",");
        }
        if (this.getFeedbackURL() != null) {
            sb.append("FeedbackURL: ").append(this.getFeedbackURL()).append(",");
        }
        if (this.getUserSettings() != null) {
            sb.append("UserSettings: ").append(this.getUserSettings()).append(",");
        }
        if (this.getApplicationSettings() != null) {
            sb.append("ApplicationSettings: ").append(this.getApplicationSettings()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAccessEndpoints() != null) {
            sb.append("AccessEndpoints: ").append(this.getAccessEndpoints()).append(",");
        }
        if (this.getEmbedHostDomains() != null) {
            sb.append("EmbedHostDomains: ").append(this.getEmbedHostDomains()).append(",");
        }
        if (this.getStreamingExperienceSettings() != null) {
            sb.append("StreamingExperienceSettings: ").append(this.getStreamingExperienceSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getStorageConnectors() == null ^ this.getStorageConnectors() == null) {
            return false;
        }
        if (other.getStorageConnectors() != null && !other.getStorageConnectors().equals(this.getStorageConnectors())) {
            return false;
        }
        if (other.getRedirectURL() == null ^ this.getRedirectURL() == null) {
            return false;
        }
        if (other.getRedirectURL() != null && !other.getRedirectURL().equals(this.getRedirectURL())) {
            return false;
        }
        if (other.getFeedbackURL() == null ^ this.getFeedbackURL() == null) {
            return false;
        }
        if (other.getFeedbackURL() != null && !other.getFeedbackURL().equals(this.getFeedbackURL())) {
            return false;
        }
        if (other.getUserSettings() == null ^ this.getUserSettings() == null) {
            return false;
        }
        if (other.getUserSettings() != null && !other.getUserSettings().equals(this.getUserSettings())) {
            return false;
        }
        if (other.getApplicationSettings() == null ^ this.getApplicationSettings() == null) {
            return false;
        }
        if (other.getApplicationSettings() != null && !other.getApplicationSettings().equals(this.getApplicationSettings())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAccessEndpoints() == null ^ this.getAccessEndpoints() == null) {
            return false;
        }
        if (other.getAccessEndpoints() != null && !other.getAccessEndpoints().equals(this.getAccessEndpoints())) {
            return false;
        }
        if (other.getEmbedHostDomains() == null ^ this.getEmbedHostDomains() == null) {
            return false;
        }
        if (other.getEmbedHostDomains() != null && !other.getEmbedHostDomains().equals(this.getEmbedHostDomains())) {
            return false;
        }
        if (other.getStreamingExperienceSettings() == null ^ this.getStreamingExperienceSettings() == null) {
            return false;
        }
        return other.getStreamingExperienceSettings() == null || other.getStreamingExperienceSettings().equals(this.getStreamingExperienceSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getStorageConnectors() == null ? 0 : this.getStorageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectURL() == null ? 0 : this.getRedirectURL().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackURL() == null ? 0 : this.getFeedbackURL().hashCode());
        hashCode = 31 * hashCode + (this.getUserSettings() == null ? 0 : this.getUserSettings().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationSettings() == null ? 0 : this.getApplicationSettings().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAccessEndpoints() == null ? 0 : this.getAccessEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getEmbedHostDomains() == null ? 0 : this.getEmbedHostDomains().hashCode());
        hashCode = 31 * hashCode + (this.getStreamingExperienceSettings() == null ? 0 : this.getStreamingExperienceSettings().hashCode());
        return hashCode;
    }

    public CreateStackRequest clone() {
        return (CreateStackRequest)super.clone();
    }
}

