/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.AppBlockState;
import com.amazonaws.services.appstream.model.ErrorDetails;
import com.amazonaws.services.appstream.model.PackagingType;
import com.amazonaws.services.appstream.model.S3Location;
import com.amazonaws.services.appstream.model.ScriptDetails;
import com.amazonaws.services.appstream.model.transform.AppBlockMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AppBlock
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String description;
    private String displayName;
    private S3Location sourceS3Location;
    private ScriptDetails setupScriptDetails;
    private Date createdTime;
    private ScriptDetails postSetupScriptDetails;
    private String packagingType;
    private String state;
    private List<ErrorDetails> appBlockErrors;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AppBlock withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public AppBlock withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public AppBlock withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AppBlock withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setSourceS3Location(S3Location sourceS3Location) {
        this.sourceS3Location = sourceS3Location;
    }

    public S3Location getSourceS3Location() {
        return this.sourceS3Location;
    }

    public AppBlock withSourceS3Location(S3Location sourceS3Location) {
        this.setSourceS3Location(sourceS3Location);
        return this;
    }

    public void setSetupScriptDetails(ScriptDetails setupScriptDetails) {
        this.setupScriptDetails = setupScriptDetails;
    }

    public ScriptDetails getSetupScriptDetails() {
        return this.setupScriptDetails;
    }

    public AppBlock withSetupScriptDetails(ScriptDetails setupScriptDetails) {
        this.setSetupScriptDetails(setupScriptDetails);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public AppBlock withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setPostSetupScriptDetails(ScriptDetails postSetupScriptDetails) {
        this.postSetupScriptDetails = postSetupScriptDetails;
    }

    public ScriptDetails getPostSetupScriptDetails() {
        return this.postSetupScriptDetails;
    }

    public AppBlock withPostSetupScriptDetails(ScriptDetails postSetupScriptDetails) {
        this.setPostSetupScriptDetails(postSetupScriptDetails);
        return this;
    }

    public void setPackagingType(String packagingType) {
        this.packagingType = packagingType;
    }

    public String getPackagingType() {
        return this.packagingType;
    }

    public AppBlock withPackagingType(String packagingType) {
        this.setPackagingType(packagingType);
        return this;
    }

    public AppBlock withPackagingType(PackagingType packagingType) {
        this.packagingType = packagingType.toString();
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public AppBlock withState(String state) {
        this.setState(state);
        return this;
    }

    public AppBlock withState(AppBlockState state) {
        this.state = state.toString();
        return this;
    }

    public List<ErrorDetails> getAppBlockErrors() {
        return this.appBlockErrors;
    }

    public void setAppBlockErrors(Collection<ErrorDetails> appBlockErrors) {
        if (appBlockErrors == null) {
            this.appBlockErrors = null;
            return;
        }
        this.appBlockErrors = new ArrayList<ErrorDetails>(appBlockErrors);
    }

    public AppBlock withAppBlockErrors(ErrorDetails ... appBlockErrors) {
        if (this.appBlockErrors == null) {
            this.setAppBlockErrors(new ArrayList<ErrorDetails>(appBlockErrors.length));
        }
        for (ErrorDetails ele : appBlockErrors) {
            this.appBlockErrors.add(ele);
        }
        return this;
    }

    public AppBlock withAppBlockErrors(Collection<ErrorDetails> appBlockErrors) {
        this.setAppBlockErrors(appBlockErrors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getSourceS3Location() != null) {
            sb.append("SourceS3Location: ").append(this.getSourceS3Location()).append(",");
        }
        if (this.getSetupScriptDetails() != null) {
            sb.append("SetupScriptDetails: ").append(this.getSetupScriptDetails()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getPostSetupScriptDetails() != null) {
            sb.append("PostSetupScriptDetails: ").append(this.getPostSetupScriptDetails()).append(",");
        }
        if (this.getPackagingType() != null) {
            sb.append("PackagingType: ").append(this.getPackagingType()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getAppBlockErrors() != null) {
            sb.append("AppBlockErrors: ").append(this.getAppBlockErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppBlock)) {
            return false;
        }
        AppBlock other = (AppBlock)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getSourceS3Location() == null ^ this.getSourceS3Location() == null) {
            return false;
        }
        if (other.getSourceS3Location() != null && !other.getSourceS3Location().equals(this.getSourceS3Location())) {
            return false;
        }
        if (other.getSetupScriptDetails() == null ^ this.getSetupScriptDetails() == null) {
            return false;
        }
        if (other.getSetupScriptDetails() != null && !other.getSetupScriptDetails().equals(this.getSetupScriptDetails())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getPostSetupScriptDetails() == null ^ this.getPostSetupScriptDetails() == null) {
            return false;
        }
        if (other.getPostSetupScriptDetails() != null && !other.getPostSetupScriptDetails().equals(this.getPostSetupScriptDetails())) {
            return false;
        }
        if (other.getPackagingType() == null ^ this.getPackagingType() == null) {
            return false;
        }
        if (other.getPackagingType() != null && !other.getPackagingType().equals(this.getPackagingType())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getAppBlockErrors() == null ^ this.getAppBlockErrors() == null) {
            return false;
        }
        return other.getAppBlockErrors() == null || other.getAppBlockErrors().equals(this.getAppBlockErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceS3Location() == null ? 0 : this.getSourceS3Location().hashCode());
        hashCode = 31 * hashCode + (this.getSetupScriptDetails() == null ? 0 : this.getSetupScriptDetails().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getPostSetupScriptDetails() == null ? 0 : this.getPostSetupScriptDetails().hashCode());
        hashCode = 31 * hashCode + (this.getPackagingType() == null ? 0 : this.getPackagingType().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getAppBlockErrors() == null ? 0 : this.getAppBlockErrors().hashCode());
        return hashCode;
    }

    public AppBlock clone() {
        try {
            return (AppBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppBlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

