/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.datastore.v1;

import com.amazon.ask.model.services.datastore.v1.CommandsDispatchResult;
import com.amazon.ask.model.services.datastore.v1.ResponsePaginationContext;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class QueuedResultResponse {
    @JsonProperty(value="items")
    private List<CommandsDispatchResult> items = new ArrayList<CommandsDispatchResult>();
    @JsonProperty(value="paginationContext")
    private ResponsePaginationContext paginationContext = null;

    private QueuedResultResponse() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private QueuedResultResponse(Builder builder) {
        if (builder.items != null) {
            this.items = builder.items;
        }
        if (builder.paginationContext != null) {
            this.paginationContext = builder.paginationContext;
        }
    }

    @JsonProperty(value="items")
    public List<CommandsDispatchResult> getItems() {
        return this.items;
    }

    @JsonProperty(value="paginationContext")
    public ResponsePaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueuedResultResponse servicesDatastoreV1QueuedResultResponse = (QueuedResultResponse)o;
        return Objects.equals(this.items, servicesDatastoreV1QueuedResultResponse.items) && Objects.equals(this.paginationContext, servicesDatastoreV1QueuedResultResponse.paginationContext);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.paginationContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueuedResultResponse {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    paginationContext: ").append(this.toIndentedString(this.paginationContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<CommandsDispatchResult> items;
        private ResponsePaginationContext paginationContext;

        private Builder() {
        }

        @JsonProperty(value="items")
        public Builder withItems(List<CommandsDispatchResult> items) {
            this.items = items;
            return this;
        }

        public Builder addItemsItem(CommandsDispatchResult itemsItem) {
            if (this.items == null) {
                this.items = new ArrayList<CommandsDispatchResult>();
            }
            this.items.add(itemsItem);
            return this;
        }

        @JsonProperty(value="paginationContext")
        public Builder withPaginationContext(ResponsePaginationContext paginationContext) {
            this.paginationContext = paginationContext;
            return this;
        }

        public QueuedResultResponse build() {
            return new QueuedResultResponse(this);
        }
    }
}

