/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.datastore.v1;

import com.amazon.ask.model.services.datastore.v1.DispatchResultType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class CommandsDispatchResult {
    @JsonProperty(value="deviceId")
    private String deviceId = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="message")
    private String message = null;

    private CommandsDispatchResult() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private CommandsDispatchResult(Builder builder) {
        if (builder.deviceId != null) {
            this.deviceId = builder.deviceId;
        }
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.message != null) {
            this.message = builder.message;
        }
    }

    @JsonProperty(value="deviceId")
    public String getDeviceId() {
        return this.deviceId;
    }

    public DispatchResultType getType() {
        return DispatchResultType.fromValue(this.type);
    }

    @JsonProperty(value="type")
    public String getTypeAsString() {
        return this.type;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandsDispatchResult servicesDatastoreV1CommandsDispatchResult = (CommandsDispatchResult)o;
        return Objects.equals(this.deviceId, servicesDatastoreV1CommandsDispatchResult.deviceId) && Objects.equals(this.type, servicesDatastoreV1CommandsDispatchResult.type) && Objects.equals(this.message, servicesDatastoreV1CommandsDispatchResult.message);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.type, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommandsDispatchResult {\n");
        sb.append("    deviceId: ").append(this.toIndentedString(this.deviceId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String deviceId;
        private String type;
        private String message;

        private Builder() {
        }

        @JsonProperty(value="deviceId")
        public Builder withDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withType(DispatchResultType type) {
            this.type = type != null ? type.toString() : null;
            return this;
        }

        @JsonProperty(value="message")
        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public CommandsDispatchResult build() {
            return new CommandsDispatchResult(this);
        }
    }
}

