/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.geolocation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Coordinate {
    @JsonProperty(value="latitudeInDegrees")
    private Double latitudeInDegrees = null;
    @JsonProperty(value="longitudeInDegrees")
    private Double longitudeInDegrees = null;
    @JsonProperty(value="accuracyInMeters")
    private Double accuracyInMeters = null;

    private Coordinate() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Coordinate(Builder builder) {
        if (builder.latitudeInDegrees != null) {
            this.latitudeInDegrees = builder.latitudeInDegrees;
        }
        if (builder.longitudeInDegrees != null) {
            this.longitudeInDegrees = builder.longitudeInDegrees;
        }
        if (builder.accuracyInMeters != null) {
            this.accuracyInMeters = builder.accuracyInMeters;
        }
    }

    @JsonProperty(value="latitudeInDegrees")
    public Double getLatitudeInDegrees() {
        return this.latitudeInDegrees;
    }

    @JsonProperty(value="longitudeInDegrees")
    public Double getLongitudeInDegrees() {
        return this.longitudeInDegrees;
    }

    @JsonProperty(value="accuracyInMeters")
    public Double getAccuracyInMeters() {
        return this.accuracyInMeters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate interfacesGeolocationCoordinate = (Coordinate)o;
        return Objects.equals(this.latitudeInDegrees, interfacesGeolocationCoordinate.latitudeInDegrees) && Objects.equals(this.longitudeInDegrees, interfacesGeolocationCoordinate.longitudeInDegrees) && Objects.equals(this.accuracyInMeters, interfacesGeolocationCoordinate.accuracyInMeters);
    }

    public int hashCode() {
        return Objects.hash(this.latitudeInDegrees, this.longitudeInDegrees, this.accuracyInMeters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Coordinate {\n");
        sb.append("    latitudeInDegrees: ").append(this.toIndentedString(this.latitudeInDegrees)).append("\n");
        sb.append("    longitudeInDegrees: ").append(this.toIndentedString(this.longitudeInDegrees)).append("\n");
        sb.append("    accuracyInMeters: ").append(this.toIndentedString(this.accuracyInMeters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Double latitudeInDegrees;
        private Double longitudeInDegrees;
        private Double accuracyInMeters;

        private Builder() {
        }

        @JsonProperty(value="latitudeInDegrees")
        public Builder withLatitudeInDegrees(Double latitudeInDegrees) {
            this.latitudeInDegrees = latitudeInDegrees;
            return this;
        }

        @JsonProperty(value="longitudeInDegrees")
        public Builder withLongitudeInDegrees(Double longitudeInDegrees) {
            this.longitudeInDegrees = longitudeInDegrees;
            return this;
        }

        @JsonProperty(value="accuracyInMeters")
        public Builder withAccuracyInMeters(Double accuracyInMeters) {
            this.accuracyInMeters = accuracyInMeters;
            return this;
        }

        public Coordinate build() {
            return new Coordinate(this);
        }
    }
}

