/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.interfaces.alexa.presentation.apl.RuntimeError;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class RuntimeErrorEvent
extends Request {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="errors")
    private List<RuntimeError> errors = new ArrayList<RuntimeError>();

    private RuntimeErrorEvent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RuntimeErrorEvent(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Alexa.Presentation.APL.RuntimeError";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.errors != null) {
            this.errors = builder.errors;
        }
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="errors")
    public List<RuntimeError> getErrors() {
        return this.errors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeErrorEvent interfacesAlexaPresentationAplRuntimeErrorEvent = (RuntimeErrorEvent)o;
        return Objects.equals(this.token, interfacesAlexaPresentationAplRuntimeErrorEvent.token) && Objects.equals(this.errors, interfacesAlexaPresentationAplRuntimeErrorEvent.errors) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.token, this.errors, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuntimeErrorEvent {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String token;
        private List<RuntimeError> errors;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="errors")
        public Builder withErrors(List<RuntimeError> errors) {
            this.errors = errors;
            return this;
        }

        public Builder addErrorsItem(RuntimeError errorsItem) {
            if (this.errors == null) {
                this.errors = new ArrayList<RuntimeError>();
            }
            this.errors.add(errorsItem);
            return this;
        }

        public RuntimeErrorEvent build() {
            return new RuntimeErrorEvent(this);
        }
    }
}

