/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.util;

import com.amazon.ask.model.services.Serializer;
import com.amazon.ask.model.services.SerializerException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JacksonSerializer
implements Serializer {
    private static ObjectMapper mapper = new ObjectMapper();

    static void setMapper(ObjectMapper objectMapper) {
        mapper = objectMapper;
    }

    @Override
    public <T> String serialize(T t) {
        try {
            return mapper.writeValueAsString(t);
        }
        catch (IOException e) {
            throw new SerializerException("Serialization error", e);
        }
    }

    @Override
    public <T> void serialize(T object, OutputStream outputStream) {
        try {
            mapper.writeValue(outputStream, object);
        }
        catch (IOException e) {
            throw new SerializerException("Serialization error");
        }
    }

    @Override
    public <T> T deserialize(String s, Class<T> aClass) {
        try {
            return (T)mapper.readValue(s, aClass);
        }
        catch (IOException e) {
            throw new SerializerException("Deserialization error", e);
        }
    }

    @Override
    public <T> T deserialize(InputStream inputStream, Class<T> type) {
        try {
            return (T)mapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new SerializerException("Deserialization error", e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

