/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.elasticsearch.eql.HitsEvent;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HitsSequence<TEvent>
implements JsonpSerializable {
    private final List<HitsEvent<TEvent>> events;
    private final List<JsonData> joinKeys;
    @Nullable
    private final JsonpSerializer<TEvent> tEventSerializer;
    public static final JsonpDeserializer<HitsSequence<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> HitsSequence.createHitsSequenceDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:eql._types.TEvent")));

    private HitsSequence(Builder<TEvent> builder) {
        this.events = ApiTypeHelper.unmodifiableRequired(((Builder)builder).events, (Object)this, "events");
        this.joinKeys = ApiTypeHelper.unmodifiableRequired(((Builder)builder).joinKeys, (Object)this, "joinKeys");
        this.tEventSerializer = ((Builder)builder).tEventSerializer;
    }

    public static <TEvent> HitsSequence<TEvent> of(Function<Builder<TEvent>, ObjectBuilder<HitsSequence<TEvent>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<HitsEvent<TEvent>> events() {
        return this.events;
    }

    public final List<JsonData> joinKeys() {
        return this.joinKeys;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.events)) {
            generator.writeKey("events");
            generator.writeStartArray();
            for (HitsEvent<TEvent> hitsEvent : this.events) {
                hitsEvent.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.joinKeys)) {
            generator.writeKey("join_keys");
            generator.writeStartArray();
            for (JsonData jsonData : this.joinKeys) {
                jsonData.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public static <TEvent> JsonpDeserializer<HitsSequence<TEvent>> createHitsSequenceDeserializer(JsonpDeserializer<TEvent> tEventDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> HitsSequence.setupHitsSequenceDeserializer(op, tEventDeserializer));
    }

    protected static <TEvent> void setupHitsSequenceDeserializer(ObjectDeserializer<Builder<TEvent>> op, JsonpDeserializer<TEvent> tEventDeserializer) {
        op.add(Builder::events, JsonpDeserializer.arrayDeserializer(HitsEvent.createHitsEventDeserializer(tEventDeserializer)), "events");
        op.add(Builder::joinKeys, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "join_keys");
    }

    public static class Builder<TEvent>
    extends WithJsonObjectBuilderBase<Builder<TEvent>>
    implements ObjectBuilder<HitsSequence<TEvent>> {
        private List<HitsEvent<TEvent>> events;
        private List<JsonData> joinKeys;
        @Nullable
        private JsonpSerializer<TEvent> tEventSerializer;

        public final Builder<TEvent> events(List<HitsEvent<TEvent>> list) {
            this.events = Builder._listAddAll(this.events, list);
            return this;
        }

        public final Builder<TEvent> events(HitsEvent<TEvent> value, HitsEvent<TEvent> ... values) {
            this.events = Builder._listAdd(this.events, value, values);
            return this;
        }

        public final Builder<TEvent> events(Function<HitsEvent.Builder<TEvent>, ObjectBuilder<HitsEvent<TEvent>>> fn) {
            return this.events(fn.apply(new HitsEvent.Builder()).build(), new HitsEvent[0]);
        }

        public final Builder<TEvent> joinKeys(List<JsonData> list) {
            this.joinKeys = Builder._listAddAll(this.joinKeys, list);
            return this;
        }

        public final Builder<TEvent> joinKeys(JsonData value, JsonData ... values) {
            this.joinKeys = Builder._listAdd(this.joinKeys, value, values);
            return this;
        }

        public final Builder<TEvent> tEventSerializer(@Nullable JsonpSerializer<TEvent> value) {
            this.tEventSerializer = value;
            return this;
        }

        @Override
        protected Builder<TEvent> self() {
            return this;
        }

        @Override
        public HitsSequence<TEvent> build() {
            this._checkSingleUse();
            return new HitsSequence(this);
        }
    }
}

