/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.geohash.queries;

import ch.hsr.geohash.BoundingBox;
import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.WGS84Point;
import ch.hsr.geohash.queries.GeoHashQuery;
import ch.hsr.geohash.util.GeoHashSizeTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeoHashBoundingBoxQuery
implements GeoHashQuery,
Serializable {
    private static final long serialVersionUID = 9223256928940522683L;
    private List<GeoHash> searchHashes = new ArrayList<GeoHash>(8);
    private BoundingBox boundingBox;

    public GeoHashBoundingBoxQuery(BoundingBox bbox) {
        if (!bbox.intersects180Meridian()) {
            this.generateSearchHashes(bbox);
        } else {
            Iterator<GeoHash> eastBox = new BoundingBox(bbox.getSouthLatitude(), bbox.getNorthLatitude(), bbox.getWestLongitude(), 180.0);
            BoundingBox westBox = new BoundingBox(bbox.getSouthLatitude(), bbox.getNorthLatitude(), -180.0, bbox.getEastLongitude());
            this.generateSearchHashes((BoundingBox)((Object)eastBox));
            this.generateSearchHashes(westBox);
        }
        for (GeoHash hash : this.searchHashes) {
            if (this.boundingBox == null) {
                this.boundingBox = new BoundingBox(hash.getBoundingBox());
                continue;
            }
            this.boundingBox.expandToInclude(hash.getBoundingBox());
        }
        for (GeoHash hash : this.searchHashes) {
            if (hash.significantBits() != 0) continue;
            this.searchHashes.clear();
            this.searchHashes.add(hash);
            return;
        }
        ArrayList<GeoHash> toRemove = new ArrayList<GeoHash>(this.searchHashes.size() - 1);
        block2: for (GeoHash hash : this.searchHashes) {
            for (GeoHash hashToCompare : this.searchHashes) {
                if (hashToCompare.significantBits() >= hash.significantBits()) continue;
                long hashCopy = hash.longValue();
                long hashCompareCopy = hashToCompare.longValue();
                int equalBits = 0;
                while ((hashCompareCopy & Long.MIN_VALUE) == (hashCopy & Long.MIN_VALUE)) {
                    hashCompareCopy <<= 1;
                    hashCopy <<= 1;
                    ++equalBits;
                }
                if (equalBits != hashToCompare.significantBits()) continue;
                toRemove.add(hash);
                continue block2;
            }
        }
        for (GeoHash hash : toRemove) {
            this.searchHashes.remove(hash);
        }
    }

    private void generateSearchHashes(BoundingBox bbox) {
        int fittingBits = GeoHashSizeTable.numberOfBitsForOverlappingGeoHash(bbox);
        WGS84Point center = bbox.getCenter();
        GeoHash centerHash = GeoHash.withBitPrecision(center.getLatitude(), center.getLongitude(), fittingBits);
        if (this.hashContainsBoundingBox(centerHash, bbox)) {
            this.searchHashes.add(centerHash);
        } else {
            this.expandSearch(centerHash, bbox);
        }
    }

    private void expandSearch(GeoHash centerHash, BoundingBox bbox) {
        this.searchHashes.add(centerHash);
        for (GeoHash adjacent : centerHash.getAdjacent()) {
            BoundingBox adjacentBox = adjacent.getBoundingBox();
            if (!adjacentBox.intersects(bbox) || this.searchHashes.contains(adjacent)) continue;
            this.searchHashes.add(adjacent);
        }
    }

    private boolean hashContainsBoundingBox(GeoHash hash, BoundingBox bbox) {
        return hash.contains(bbox.getNorthWestCorner()) && hash.contains(bbox.getSouthEastCorner());
    }

    @Override
    public boolean contains(GeoHash hash) {
        for (GeoHash searchHash : this.searchHashes) {
            if (!hash.within(searchHash)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(WGS84Point point) {
        return this.contains(GeoHash.withBitPrecision(point.getLatitude(), point.getLongitude(), 64));
    }

    @Override
    public List<GeoHash> getSearchHashes() {
        return this.searchHashes;
    }

    public String toString() {
        StringBuilder bui = new StringBuilder();
        for (GeoHash hash : this.searchHashes) {
            bui.append(hash).append("\n");
        }
        return bui.toString();
    }

    @Override
    public String getWktBox() {
        return "BOX(" + this.boundingBox.getWestLongitude() + " " + this.boundingBox.getSouthLatitude() + "," + this.boundingBox.getEastLongitude() + " " + this.boundingBox.getNorthLatitude() + ")";
    }
}

