/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.geohash;

import ch.hsr.geohash.WGS84Point;
import java.io.Serializable;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = -7145192134410261076L;
    private double southLatitude;
    private double northLatitude;
    private double westLongitude;
    private double eastLongitude;
    private boolean intersects180Meridian;

    public BoundingBox(WGS84Point southWestCorner, WGS84Point northEastCorner) {
        this(southWestCorner.getLatitude(), northEastCorner.getLatitude(), southWestCorner.getLongitude(), northEastCorner.getLongitude());
    }

    public BoundingBox(double southLatitude, double northLatitude, double westLongitude, double eastLongitude) {
        if (southLatitude > northLatitude) {
            throw new IllegalArgumentException("The southLatitude must not be greater than the northLatitude");
        }
        if (Math.abs(southLatitude) > 90.0 || Math.abs(northLatitude) > 90.0 || Math.abs(westLongitude) > 180.0 || Math.abs(eastLongitude) > 180.0) {
            throw new IllegalArgumentException("The supplied coordinates are out of range.");
        }
        this.northLatitude = northLatitude;
        this.westLongitude = westLongitude;
        this.southLatitude = southLatitude;
        this.eastLongitude = eastLongitude;
        this.intersects180Meridian = eastLongitude < westLongitude;
    }

    public BoundingBox(BoundingBox that) {
        this(that.southLatitude, that.northLatitude, that.westLongitude, that.eastLongitude);
    }

    public WGS84Point getNorthWestCorner() {
        return new WGS84Point(this.northLatitude, this.westLongitude);
    }

    public WGS84Point getNorthEastCorner() {
        return new WGS84Point(this.northLatitude, this.eastLongitude);
    }

    public WGS84Point getSouthEastCorner() {
        return new WGS84Point(this.southLatitude, this.eastLongitude);
    }

    public WGS84Point getSouthWestCorner() {
        return new WGS84Point(this.southLatitude, this.westLongitude);
    }

    public double getLatitudeSize() {
        return this.northLatitude - this.southLatitude;
    }

    public double getLongitudeSize() {
        if (this.eastLongitude == 180.0 && this.westLongitude == -180.0) {
            return 360.0;
        }
        double size = (this.eastLongitude - this.westLongitude) % 360.0;
        if (size < 0.0) {
            size += 360.0;
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BoundingBox) {
            BoundingBox that = (BoundingBox)obj;
            return this.southLatitude == that.southLatitude && this.westLongitude == that.westLongitude && this.northLatitude == that.northLatitude && this.eastLongitude == that.eastLongitude;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + BoundingBox.hashCode(this.southLatitude);
        result = 37 * result + BoundingBox.hashCode(this.northLatitude);
        result = 37 * result + BoundingBox.hashCode(this.westLongitude);
        result = 37 * result + BoundingBox.hashCode(this.eastLongitude);
        return result;
    }

    private static int hashCode(double x) {
        long f = Double.doubleToLongBits(x);
        return (int)(f ^ f >>> 32);
    }

    public boolean contains(WGS84Point point) {
        return this.containsLatitude(point.getLatitude()) && this.containsLongitude(point.getLongitude());
    }

    public boolean intersects(BoundingBox other) {
        if (other.southLatitude > this.northLatitude || other.northLatitude < this.southLatitude) {
            return false;
        }
        if (!this.intersects180Meridian && !other.intersects180Meridian) {
            return !(other.eastLongitude < this.westLongitude) && !(other.westLongitude > this.eastLongitude);
        }
        if (this.intersects180Meridian && !other.intersects180Meridian) {
            return !(this.eastLongitude < other.westLongitude) || !(this.westLongitude > other.eastLongitude);
        }
        if (!this.intersects180Meridian && other.intersects180Meridian) {
            return !(this.westLongitude > other.eastLongitude) || !(this.eastLongitude < other.westLongitude);
        }
        return true;
    }

    public String toString() {
        return this.getNorthWestCorner() + " -> " + this.getSouthEastCorner();
    }

    public WGS84Point getCenter() {
        double centerLatitude = (this.southLatitude + this.northLatitude) / 2.0;
        double centerLongitude = (this.westLongitude + this.eastLongitude) / 2.0;
        if (centerLongitude > 180.0) {
            centerLongitude -= 360.0;
        }
        return new WGS84Point(centerLatitude, centerLongitude);
    }

    public void expandToInclude(BoundingBox other) {
        boolean otherContainsThis;
        if (other.southLatitude < this.southLatitude) {
            this.southLatitude = other.southLatitude;
        }
        if (other.northLatitude > this.northLatitude) {
            this.northLatitude = other.northLatitude;
        }
        boolean thisContainsOther = this.containsLongitude(other.eastLongitude) && this.containsLongitude(other.westLongitude);
        boolean bl = otherContainsThis = other.containsLongitude(this.eastLongitude) && other.containsLongitude(this.westLongitude);
        if (thisContainsOther && otherContainsThis) {
            this.eastLongitude = 180.0;
            this.westLongitude = -180.0;
            this.intersects180Meridian = false;
            return;
        }
        if (thisContainsOther) {
            return;
        }
        if (otherContainsThis) {
            this.eastLongitude = other.eastLongitude;
            this.westLongitude = other.westLongitude;
            this.intersects180Meridian = this.eastLongitude < this.westLongitude;
            return;
        }
        double distanceEastToOtherEast = (other.eastLongitude - this.eastLongitude) % 360.0;
        double distanceOtherWestToWest = (this.westLongitude - other.westLongitude) % 360.0;
        if (distanceEastToOtherEast < 0.0) {
            distanceEastToOtherEast += 360.0;
        }
        if (distanceOtherWestToWest < 0.0) {
            distanceOtherWestToWest += 360.0;
        }
        if (distanceEastToOtherEast <= distanceOtherWestToWest) {
            this.eastLongitude = other.eastLongitude;
        } else {
            this.westLongitude = other.westLongitude;
        }
        this.intersects180Meridian = this.eastLongitude < this.westLongitude;
    }

    private boolean containsLatitude(double latitude) {
        return latitude >= this.southLatitude && latitude <= this.northLatitude;
    }

    private boolean containsLongitude(double longitude) {
        if (this.intersects180Meridian) {
            return longitude <= this.eastLongitude || longitude >= this.westLongitude;
        }
        return longitude >= this.westLongitude && longitude <= this.eastLongitude;
    }

    public double getEastLongitude() {
        return this.eastLongitude;
    }

    public double getWestLongitude() {
        return this.westLongitude;
    }

    public double getNorthLatitude() {
        return this.northLatitude;
    }

    public double getSouthLatitude() {
        return this.southLatitude;
    }

    public boolean intersects180Meridian() {
        return this.intersects180Meridian;
    }
}

