/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.sockets;

import ca.uhn.hl7v2.hoh.sockets.ISocketFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCertificateTlsSocketFactory
implements ISocketFactory {
    private static final Logger ourLog = LoggerFactory.getLogger(CustomCertificateTlsSocketFactory.class);
    private KeyStore myKeystore;
    private String myKeystoreFilename;
    private String myKeystorePassphrase;
    private String myKeystoreType = "JKS";
    private SSLServerSocketFactory myServerSocketFactory;
    private SSLSocketFactory mySocketFactory = null;

    public CustomCertificateTlsSocketFactory() {
    }

    public CustomCertificateTlsSocketFactory(KeyStore theKeystore, String theKeystorePass) {
        if (theKeystore == null) {
            throw new NullPointerException("KeyStore can not be null");
        }
        this.myKeystore = theKeystore;
        this.myKeystorePassphrase = theKeystorePass;
    }

    public CustomCertificateTlsSocketFactory(String theKeystoreType, String theKeystoreFilename, String theKeystorePassphrase) {
        this.myKeystoreType = theKeystoreType;
        this.myKeystoreFilename = theKeystoreFilename;
        this.myKeystorePassphrase = theKeystorePassphrase;
    }

    @Override
    public Socket createClientSocket() throws IOException {
        this.initialize();
        ourLog.debug("Creating client socket");
        return this.mySocketFactory.createSocket();
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        this.initialize();
        ourLog.debug("Creating server socket");
        return this.myServerSocketFactory.createServerSocket();
    }

    private void initialize() throws IOException {
        if (this.mySocketFactory != null) {
            return;
        }
        try {
            char[] passphrase;
            char[] cArray = passphrase = this.myKeystorePassphrase != null ? this.myKeystorePassphrase.toCharArray() : null;
            if (this.myKeystore == null) {
                this.myKeystore = KeyStore.getInstance(this.myKeystoreType);
                try {
                    this.myKeystore.load(new FileInputStream(this.myKeystoreFilename), passphrase);
                }
                catch (IOException e) {
                    throw new IOException("Failed to load keystore: " + this.myKeystoreFilename, e);
                }
            }
            SSLContext ctx = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            kmf.init(this.myKeystore, passphrase);
            tmf.init(this.myKeystore);
            TrustManager[] trustManagers = tmf.getTrustManagers();
            KeyManager[] keyManagers = kmf.getKeyManagers();
            ctx.init(keyManagers, trustManagers, null);
            this.mySocketFactory = ctx.getSocketFactory();
            this.myServerSocketFactory = ctx.getServerSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to initialize socket factory: " + e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new IOException("Failed to initialize socket factory: " + e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Failed to initialize socket factory: " + e.getMessage(), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException("Failed to initialize socket factory: " + e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new IOException("Failed to initialize socket factory: " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            throw new IOException("Failed to initialize socket factory: " + e.getMessage(), e);
        }
    }

    public void setKeystoreFilename(String theKeystoreFilename) {
        this.myKeystoreFilename = theKeystoreFilename;
    }

    public void setKeystorePassphrase(String theKeystorePassphrase) {
        this.myKeystorePassphrase = theKeystorePassphrase;
    }

    public void setKeystoreType(String theKeystoreType) {
        this.myKeystoreType = theKeystoreType;
    }
}

