/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.relay.sender;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.hapi.api.MessageSendable;
import ca.uhn.hl7v2.hoh.hapi.client.HohClientMultithreaded;
import ca.uhn.hl7v2.hoh.relay.Binder;
import ca.uhn.hl7v2.hoh.relay.sender.IRelaySender;
import ca.uhn.hl7v2.hoh.util.Validate;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.protocol.ReceivingApplicationException;
import ca.uhn.hl7v2.util.Terser;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class RelayHttpSender
extends HohClientMultithreaded
implements IRelaySender<Message>,
BeanNameAware,
InitializingBean {
    private static final Logger ourLog = LoggerFactory.getLogger(RelayHttpSender.class);
    private String myBeanName;
    private int myIoRetries = 0;

    public void afterPropertiesSet() throws Exception {
        Validate.propertySet(this.getUrl(), "Url");
        ourLog.info("Sender [{}] will transmit by HL7 over HTTP to {}", (Object)this.myBeanName, (Object)this.getUrl().toExternalForm());
    }

    public boolean canProcess(Message theMessage) {
        return true;
    }

    public String getBeanName() {
        return this.myBeanName;
    }

    public int getIoRetries() {
        return this.myIoRetries;
    }

    public Message processMessage(Message theMessage, Map<String, Object> theMetadata) throws ReceivingApplicationException, HL7Exception {
        IReceivable<Message> response;
        String sendingIp = (String)theMetadata.get("SENDING_IP");
        Object sendingPort = theMetadata.get("SENDING_PORT");
        String controlId = (String)theMetadata.get("/MSH-10");
        String rawMessage = (String)theMetadata.get("raw-message");
        ourLog.info("Relaying message ({} bytes) with ID {} from {}:{} to URL {}", new Object[]{rawMessage.length(), controlId, sendingIp, sendingPort, this.getUrl()});
        long delay = System.currentTimeMillis();
        int attempt = -1;
        while (true) {
            if (++attempt > 0) {
                ourLog.info("This is attempt {}", (Object)attempt);
            }
            try {
                response = this.sendAndReceiveMessage(new MessageSendable(theMessage));
                delay = System.currentTimeMillis() - delay;
            }
            catch (DecodeException e) {
                ourLog.error("Failed to process HL7 over HTTP response from URL \"" + this.getUrl().toExternalForm() + "\"", (Throwable)e);
                throw new HL7Exception(String.valueOf(Binder.getProductname()) + " - Failed to process HL7 over HTTP response from URL \"" + this.getUrl().toExternalForm() + "\" - Error was: " + e.getMessage());
            }
            catch (ConnectException e) {
                ourLog.info("Failed to connect to URL \"" + this.getUrl().toExternalForm() + "\" - Error was: " + e.getMessage());
                throw new HL7Exception(String.valueOf(Binder.getProductname()) + " - Failed to connect to URL \"" + this.getUrl().toExternalForm() + "\" - Error was: " + e.getMessage());
            }
            catch (IOException e) {
                if (attempt < this.myIoRetries) {
                    ourLog.warn("Got an IOException, going to retry transmission: " + e.toString());
                    continue;
                }
                ourLog.error("IO Exception communicating with URL \"" + this.getUrl().toExternalForm() + "\"", (Throwable)e);
                throw new HL7Exception(String.valueOf(Binder.getProductname()) + " - IO Exception communicating with URL URL \"" + this.getUrl().toExternalForm() + "\" - Error was: " + e.getMessage());
            }
            catch (EncodeException e) {
                ourLog.error("Failed to create HTTP request", (Throwable)e);
                throw new HL7Exception(String.valueOf(Binder.getProductname()) + " - Failed to create HTTP request - Error was: " + e.getMessage());
            }
            break;
        }
        String responseControlId = new Terser(response.getMessage()).get("/MSH-10");
        ourLog.info("Received response to ID {} with ID {} in {} ms", new Object[]{controlId, responseControlId, delay});
        return response.getMessage();
    }

    public void setBeanName(String theBeanName) {
        this.myBeanName = theBeanName;
    }

    public void setIoRetries(int theIoRetries) {
        this.myIoRetries = theIoRetries;
    }
}

