/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.relay;

import ca.uhn.hl7v2.hoh.relay.listener.IRelayListener;
import ca.uhn.hl7v2.hoh.relay.sender.IRelaySender;
import ca.uhn.hl7v2.hoh.util.Validate;
import ca.uhn.hl7v2.hoh.util.VersionLogger;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.impl.AppRoutingDataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class Binder
implements InitializingBean {
    private static final Logger ourLog = LoggerFactory.getLogger(Binder.class);
    private static final String ourProductName = "HAPI HL7 over HTTP Relay " + VersionLogger.getVersion();
    private String myMessageType = "*";
    private String myProcessingId = "*";
    private IRelayListener myRelayListener;
    private IRelaySender myRelaySender;
    private String myTriggerEvent = "*";
    private String myVersionId = "*";

    public void afterPropertiesSet() throws Exception {
        Validate.propertySet(this.myRelayListener, "listener");
        Validate.propertySet(this.myRelaySender, "sender");
        ourLog.info("Binding sender[{}] to listener[{}] for messages with profile[MsgType:{} / MsgTrigger:{} / Version:{} / Processing:{}]", new Object[]{this.myRelaySender.getBeanName(), this.myRelayListener.getBeanName(), this.myMessageType, this.myTriggerEvent, this.myVersionId, this.myProcessingId});
        AppRoutingDataImpl appRoutingData = new AppRoutingDataImpl(this.myMessageType, this.myTriggerEvent, this.myProcessingId, this.myVersionId);
        this.myRelayListener.registerApplication((ApplicationRouter.AppRoutingData)appRoutingData, this.myRelaySender);
    }

    public void setListener(IRelayListener theRelayListener) {
        this.myRelayListener = theRelayListener;
    }

    public void setSender(IRelaySender theRelaySender) {
        this.myRelaySender = theRelaySender;
    }

    public static String getProductname() {
        return ourProductName;
    }
}

