/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.hapi.client;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.api.IAuthorizationClientCallback;
import ca.uhn.hl7v2.hoh.api.IClient;
import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.api.ISendable;
import ca.uhn.hl7v2.hoh.hapi.api.MessageReceivable;
import ca.uhn.hl7v2.hoh.hapi.api.MessageSendable;
import ca.uhn.hl7v2.hoh.raw.client.AbstractRawClient;
import ca.uhn.hl7v2.hoh.sign.ISigner;
import ca.uhn.hl7v2.hoh.sockets.ISocketFactory;
import ca.uhn.hl7v2.hoh.util.Validate;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Parser;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;

public abstract class AbstractClient<T extends AbstractRawClient>
implements IClient {
    private Parser myParser;
    private T myRawClient;

    public AbstractClient(T theRawClient) {
        this(theRawClient, null);
    }

    @Override
    public void setKeepAlive(boolean theKeepAlive) {
        ((AbstractRawClient)this.getRawClient()).setKeepAlive(theKeepAlive);
    }

    @Override
    public boolean isKeepAlive() {
        return ((AbstractRawClient)this.getRawClient()).isKeepAlive();
    }

    @Override
    public void setSoTimeout(int theSoTimeout) {
        ((AbstractRawClient)this.getRawClient()).setSoTimeout(theSoTimeout);
    }

    @Override
    public int getSoTimeout() {
        return ((AbstractRawClient)this.getRawClient()).getSoTimeout();
    }

    protected AbstractClient(T theRawClient, Parser theParser) {
        Validate.notNull(theRawClient, "rawClient");
        this.myRawClient = theRawClient;
        this.myParser = theParser;
    }

    @Override
    public String getHost() {
        return ((AbstractRawClient)this.myRawClient).getHost();
    }

    public Parser getParser() {
        return this.myParser;
    }

    @Override
    public int getPort() {
        return ((AbstractRawClient)this.myRawClient).getPort();
    }

    protected T getRawClient() {
        return this.myRawClient;
    }

    @Override
    public ISocketFactory getSocketFactory() {
        return ((AbstractRawClient)this.myRawClient).getSocketFactory();
    }

    @Override
    public String getUriPath() {
        return ((AbstractRawClient)this.myRawClient).getUriPath();
    }

    @Override
    public URL getUrl() {
        return ((AbstractRawClient)this.myRawClient).getUrl();
    }

    @Override
    public String getUrlString() {
        return ((AbstractRawClient)this.myRawClient).getUrlString();
    }

    public IReceivable<Message> sendAndReceiveMessage(ISendable<Message> theMessageToSend) throws DecodeException, IOException, EncodeException, EncodingNotSupportedException, HL7Exception {
        IReceivable<String> response = ((AbstractRawClient)this.myRawClient).sendAndReceive(theMessageToSend);
        Parser parser = this.myParser != null ? this.myParser : theMessageToSend.getMessage().getParser();
        return new MessageReceivable(parser.parse(response.getMessage()));
    }

    public IReceivable<Message> sendAndReceiveMessage(Message theMessageToSend) throws DecodeException, IOException, EncodeException, EncodingNotSupportedException, HL7Exception {
        MessageSendable sendable = new MessageSendable(theMessageToSend);
        return this.sendAndReceiveMessage(sendable);
    }

    @Override
    public void setAuthorizationCallback(IAuthorizationClientCallback theAuthorizationCallback) {
        ((AbstractRawClient)this.myRawClient).setAuthorizationCallback(theAuthorizationCallback);
    }

    @Override
    public void setCharset(Charset theCharset) {
        ((AbstractRawClient)this.myRawClient).setCharset(theCharset);
    }

    @Override
    public void setHost(String theHost) {
        ((AbstractRawClient)this.myRawClient).setHost(theHost);
    }

    public void setParser(Parser theParser) {
        Validate.notNull(theParser, "parser");
        this.myParser = theParser;
    }

    @Override
    public void setUriPath(String thePath) {
        ((AbstractRawClient)this.myRawClient).setUriPath(thePath);
    }

    @Override
    public void setPort(int thePort) {
        ((AbstractRawClient)this.myRawClient).setPort(thePort);
    }

    @Override
    public void setResponseTimeout(long theResponseTimeout) {
        ((AbstractRawClient)this.myRawClient).setResponseTimeout(theResponseTimeout);
    }

    @Override
    public void setSigner(ISigner theSigner) {
        ((AbstractRawClient)this.myRawClient).setSigner(theSigner);
    }

    @Override
    public void setSocketFactory(ISocketFactory theSocketFactory) {
        ((AbstractRawClient)this.myRawClient).setSocketFactory(theSocketFactory);
    }

    @Override
    public void setUrl(URL theUrl) {
        ((AbstractRawClient)this.myRawClient).setUrl(theUrl);
    }

    @Override
    public void setUrlString(String theString) {
        ((AbstractRawClient)this.myRawClient).setUrlString(theString);
    }
}

