/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import java.util.HashMap;
import java.util.Map;

public enum EncodingStyle {
    ER7("application/hl7-v2"),
    XML("application/hl7-v2+xml");

    private static final Map<String, EncodingStyle> ourContentTypeToEncodingStyles;
    private String myContentType;

    static {
        ourContentTypeToEncodingStyles = new HashMap<String, EncodingStyle>();
        EncodingStyle[] encodingStyleArray = EncodingStyle.values();
        int n = encodingStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            EncodingStyle next = encodingStyleArray[n2];
            ourContentTypeToEncodingStyles.put(next.myContentType, next);
            ++n2;
        }
    }

    private EncodingStyle(String theContentType) {
        this.myContentType = theContentType;
    }

    public static EncodingStyle getEncodingStyleForContentType(String theContentType) {
        return ourContentTypeToEncodingStyles.get(theContentType.toLowerCase());
    }

    public static EncodingStyle detect(String theMessage) {
        if (theMessage == null) {
            throw new NullPointerException("Message can not be null");
        }
        int i = 0;
        while (i < theMessage.length()) {
            char nextChar = theMessage.charAt(i);
            if (Character.isLetter(nextChar)) {
                return ER7;
            }
            if (!Character.isWhitespace(nextChar) && nextChar == '<') {
                return XML;
            }
            ++i;
        }
        throw new IllegalArgumentException("Message does not appear to be ER7 or XML");
    }

    public String getContentType() {
        return this.myContentType;
    }
}

