/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.layout.ListLayoutManager;
import ar.com.fdvs.dj.util.Utils;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtendedListLayoutManager
extends ListLayoutManager {
    private static final Log log = LogFactory.getLog(ListLayoutManager.class);

    @Override
    protected void startLayout() {
        super.startLayout();
        this.generateTitleBand();
    }

    protected void generateTitleBand() {
        log.debug((Object)"Generating title band...");
        JRDesignBand band = (JRDesignBand)this.getDesign().getPageHeader();
        int yOffset = 0;
        if (this.getReport().getTitle() == null) {
            return;
        }
        if (band != null && !this.getDesign().isTitleNewPage()) {
            yOffset = band.getHeight();
        } else {
            band = (JRDesignBand)this.getDesign().getTitle();
            if (band == null) {
                band = new JRDesignBand();
                this.getDesign().setTitle((JRBand)band);
            }
        }
        JRDesignTextField title = new JRDesignTextField();
        JRDesignExpression exp = new JRDesignExpression();
        if (this.getReport().isTitleIsJrExpression()) {
            exp.setText(this.getReport().getTitle());
        } else {
            exp.setText("\"" + Utils.escapeTextForExpression(this.getReport().getTitle()) + "\"");
        }
        exp.setValueClass(String.class);
        title.setExpression((JRExpression)exp);
        title.setWidth(this.getReport().getOptions().getPrintableWidth());
        title.setHeight(this.getReport().getOptions().getTitleHeight());
        title.setY(yOffset);
        title.setRemoveLineWhenBlank(true);
        this.applyStyleToElement(this.getReport().getTitleStyle(), (JRDesignElement)title);
        title.setStretchType(StretchTypeEnum.NO_STRETCH);
        band.addElement((JRDesignElement)title);
        JRDesignTextField subtitle = new JRDesignTextField();
        if (this.getReport().getSubtitle() != null) {
            JRDesignExpression exp2 = new JRDesignExpression();
            exp2.setText("\"" + this.getReport().getSubtitle() + "\"");
            exp2.setValueClass(String.class);
            subtitle.setExpression((JRExpression)exp2);
            subtitle.setWidth(this.getReport().getOptions().getPrintableWidth());
            subtitle.setHeight(this.getReport().getOptions().getSubtitleHeight());
            subtitle.setY(title.getY() + title.getHeight());
            subtitle.setRemoveLineWhenBlank(true);
            this.applyStyleToElement(this.getReport().getSubtitleStyle(), (JRDesignElement)subtitle);
            title.setStretchType(StretchTypeEnum.NO_STRETCH);
            band.addElement((JRDesignElement)subtitle);
        }
    }
}

