
package org.nuiton.web.tapestry5.services;

import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.LibraryMapping;

/**
 * NuitonModule
 *
 * Created: 4 mai 2010
 *
 * @author fdesbois
 * $Id: NuitonModule.java 5 2010-05-04 16:23:44Z fdesbois $
 */
public class NuitonModule {

    private static final String PACKAGE_ROOT = "org.nuiton.web.tapestry5";

    public void contributeComponentClassResolver(
            Configuration<LibraryMapping> configuration) {

        configuration.add(new LibraryMapping("nuiton", PACKAGE_ROOT));
    }

    public static void contributeBindingSource(
            MappedConfiguration<String, BindingFactory> configuration,
            BindingSource bindingSource) {

        configuration.add("format", new FormatBindingFactory(bindingSource));
    }

}
