/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.struts2.interceptor.BackgroundProcess;
import org.apache.struts2.interceptor.ExecuteAndWaitInterceptor;
import org.nuiton.web.struts2.interceptor.HasUploadedFile;

public class UploadExecuteAndWaitInterceptor
extends ExecuteAndWaitInterceptor {
    protected BackgroundProcess getNewBackgroundProcess(String name, ActionInvocation actionInvocation, int threadPriority) {
        BackgroundProcess bgProcess;
        if (actionInvocation.getAction() instanceof HasUploadedFile) {
            HasUploadedFile uploadAction = (HasUploadedFile)actionInvocation.getAction();
            try {
                File origFile = uploadAction.getUploadedFile();
                if (origFile != null) {
                    File altFile = new File(origFile.getParentFile(), origFile.getName() + "-alt.tmp");
                    FileUtils.copyFile((File)origFile, (File)altFile);
                    altFile.deleteOnExit();
                    uploadAction.setUploadedFile(altFile);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Error copying uploaded file", ex);
            }
            bgProcess = new UploadBackgroundProcess(name + "BackgroundThread", actionInvocation, threadPriority);
        } else {
            bgProcess = super.getNewBackgroundProcess(name, actionInvocation, threadPriority);
        }
        return bgProcess;
    }

    private class UploadBackgroundProcess
    extends BackgroundProcess {
        public UploadBackgroundProcess(String threadName, ActionInvocation invocation, int threadPriority) {
            super(threadName, invocation, threadPriority);
        }

        protected void afterInvocation() throws Exception {
            super.afterInvocation();
            FileUtils.deleteQuietly((File)((HasUploadedFile)this.getAction()).getUploadedFile());
        }
    }
}

