package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.web.AbstractSecurityTopiaDao;
import org.nuiton.web.SecurityEntityEnum;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Wed Dec 20 14:31:22 CET 2017")
public abstract class GeneratedSecurityUserTopiaDao<E extends SecurityUser> extends AbstractSecurityTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) SecurityUser.class;
    }

    @Override
    public SecurityEntityEnum getTopiaEntityEnum() {
        return SecurityEntityEnum.SecurityUser;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLoginIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SecurityUser.PROPERTY_LOGIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLoginEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SecurityUser.PROPERTY_LOGIN, v);
        return result;
    }

    @Deprecated
    public E findByLogin(String v) {
        return forLoginEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLogin(String v) {
        return forLoginEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SecurityUser.PROPERTY_PASSWORD, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SecurityUser.PROPERTY_PASSWORD, v);
        return result;
    }

    @Deprecated
    public E findByPassword(String v) {
        return forPasswordEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPassword(String v) {
        return forPasswordEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExternalIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SecurityUser.PROPERTY_EXTERNAL_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExternalIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SecurityUser.PROPERTY_EXTERNAL_ID, v);
        return result;
    }

    @Deprecated
    public E findByExternalId(String v) {
        return forExternalIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByExternalId(String v) {
        return forExternalIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSecurityRoleContains(SecurityRole v) {
        return forContains(SecurityUser.PROPERTY_SECURITY_ROLE, v);
    }

    @Deprecated
    public E findContainsSecurityRole(SecurityRole v) {
        return forSecurityRoleContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsSecurityRole(SecurityRole v) {
        return forSecurityRoleContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedSecurityUserTopiaDao<E extends SecurityUser>
