/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.i18n.I18n;
import org.nuiton.web.security.actions.AbstractAction;

public class LoginAction
extends AbstractAction
implements ServletRequestAware,
ServletResponseAware {
    private static final Log log = LogFactory.getLog(LoginAction.class);
    private static final long serialVersionUID = 1L;
    protected String login;
    protected String password;
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String execute() throws Exception {
        String result = null;
        if (this.login == null || this.password == null) {
            result = this.input();
        } else {
            try {
                Subject currentUser = SecurityUtils.getSubject();
                UsernamePasswordToken token = new UsernamePasswordToken(this.login, this.password);
                currentUser.login((AuthenticationToken)token);
                result = "success";
                Session session = currentUser.getSession();
                String requestURL = (String)session.getAttribute((Object)"savedUrl");
                if (this.request != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirecting to saved url " + requestURL));
                    }
                    session.removeAttribute((Object)"savedUrl");
                    this.response.sendRedirect(requestURL);
                }
            }
            catch (UnknownAccountException ex) {
                this.addActionError(I18n._((String)"Identifiant ou mot de passe invalide !", (Object[])new Object[0]));
                log.warn((Object)"Unknow user account", (Throwable)ex);
                result = this.input();
            }
            catch (IncorrectCredentialsException ex) {
                this.addActionError(I18n._((String)"Identifiant ou mot de passe invalide !", (Object[])new Object[0]));
                log.warn((Object)"Invalid password", (Throwable)ex);
                result = this.input();
            }
            catch (LockedAccountException ex) {
                this.addActionError(I18n._((String)"Compte bloqu\u00e9. Contacter un administrateur", (Object[])new Object[0]));
                log.error((Object)"Account locked error", (Throwable)ex);
                result = this.input();
            }
            catch (ExcessiveAttemptsException ex) {
                this.addActionError(I18n._((String)"Nombre de tentatives d\u00e9pass\u00e9", (Object[])new Object[0]));
                log.error((Object)"Excessive attemps error", (Throwable)ex);
                result = this.input();
            }
            catch (AuthenticationException ex) {
                this.addActionError(ex.getMessage());
                log.warn((Object)"Authentication error", (Throwable)ex);
                result = this.input();
            }
        }
        return result;
    }
}

