/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContext;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContextConstructorParameter;
import org.nuiton.topia.templates.TopiaCoreTagValues;
import org.nuiton.topia.templates.TopiaTemplateHelper;

@Component(role=Template.class, hint="org.nuiton.topia.templates.PersistenceContextTransformer")
public class PersistenceContextTransformer
extends ObjectModelTransformerToJava {
    protected TopiaTemplateHelper templateHelper;
    protected final TopiaCoreTagValues topiaCoreTagValues = new TopiaCoreTagValues();

    public void transformFromModel(ObjectModel input) {
        boolean generateConcrete;
        if (this.templateHelper == null) {
            this.templateHelper = new TopiaTemplateHelper((ObjectModel)this.model);
        }
        String packageName = this.templateHelper.getPersistenceContextPackage(this, (ObjectModel)this.model);
        String daoSupplierName = this.templateHelper.getDaoSupplierName((ObjectModel)this.model);
        String persistenceContextAbstractName = this.templateHelper.getPersistenceContextAbstractName((ObjectModel)this.model);
        String persistenceContextConcreteName = this.templateHelper.getPersistenceContextConcreteName((ObjectModel)this.model);
        boolean generateDaoSupplier = !this.getResourcesHelper().isJavaFileInClassPath(packageName + "." + daoSupplierName);
        boolean generateAbstract = !this.getResourcesHelper().isJavaFileInClassPath(packageName + "." + persistenceContextAbstractName);
        boolean bl = generateConcrete = !this.getResourcesHelper().isJavaFileInClassPath(packageName + "." + persistenceContextConcreteName);
        if (generateDaoSupplier) {
            this.generateDaoSupplier(packageName, daoSupplierName);
        }
        if (generateAbstract) {
            this.generateAbstract(packageName, persistenceContextAbstractName, daoSupplierName);
        }
        if (generateConcrete) {
            this.generateImpl(packageName, persistenceContextAbstractName, persistenceContextConcreteName);
        }
    }

    protected void generateDaoSupplier(String packageName, String className) {
        ObjectModelInterface output = this.createInterface(className, packageName);
        String contractName = this.templateHelper.getDaoSupplierInterfaceName((ObjectModel)this.model);
        boolean addPersistenceContextContract = this.getResourcesHelper().isJavaFileInClassPath(packageName + "." + contractName);
        if (addPersistenceContextContract) {
            this.addInterface((ObjectModelClassifier)output, packageName + "." + contractName);
        }
        this.addInterface((ObjectModelClassifier)output, TopiaDaoSupplier.class);
        List<ObjectModelClass> entityClasses = this.templateHelper.getEntityClasses((ObjectModel)this.model, true);
        for (ObjectModelClass clazz : entityClasses) {
            String daoContractName = this.templateHelper.getContractDaoName(clazz);
            String daoClazzName = this.templateHelper.getConcreteDaoName(clazz);
            this.addOperation((ObjectModelClassifier)output, "get" + daoContractName, clazz.getPackageName() + "." + daoClazzName, new ObjectModelModifier[0]);
        }
    }

    protected void generateAbstract(String packageName, String className, String daoSupplierName) {
        ObjectModelClass output = this.createAbstractClass(className, packageName);
        String superClass = this.topiaCoreTagValues.getPersistenceContextSuperClassTagValue((ObjectModel)this.model);
        if (superClass == null) {
            superClass = AbstractTopiaPersistenceContext.class.getName();
        }
        this.setSuperClass(output, superClass);
        String contractName = this.templateHelper.getPersistenceContextInterfaceName((ObjectModel)this.model);
        boolean addPersistenceContextContract = this.getResourcesHelper().isJavaFileInClassPath(packageName + "." + contractName);
        if (addPersistenceContextContract) {
            this.addInterface((ObjectModelClassifier)output, packageName + "." + contractName);
        }
        this.addInterface((ObjectModelClassifier)output, packageName + "." + daoSupplierName);
        this.addContructor(output, false);
        List<ObjectModelClass> entityClasses = this.templateHelper.getEntityClasses((ObjectModel)this.model, true);
        for (ObjectModelClass clazz : entityClasses) {
            String clazzName = clazz.getName();
            String daoContractName = this.templateHelper.getContractDaoName(clazz);
            String daoClazzName = this.templateHelper.getConcreteDaoName(clazz);
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "get" + daoContractName, clazz.getPackageName() + "." + daoClazzName, new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class);
            this.addImport((ObjectModelClassifier)output, clazz);
            this.setOperationBody(op, "\n        " + daoClazzName + " result = getDao(" + clazzName + ".class, " + daoClazzName + ".class);\n        return result;\n    ");
        }
    }

    protected ObjectModelClass generateImpl(String packageName, String entityAbstractName, String entityConcreteName) {
        ObjectModelClass output = this.createClass(entityConcreteName, packageName);
        this.setSuperClass(output, entityAbstractName);
        this.addContructor(output, true);
        return output;
    }

    protected void addContructor(ObjectModelClass output, boolean isPublic) {
        ObjectModelJavaModifier visibility = isPublic ? ObjectModelJavaModifier.PUBLIC : ObjectModelJavaModifier.PROTECTED;
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)visibility);
        this.addParameter(constructor, AbstractTopiaPersistenceContextConstructorParameter.class, "parameter");
        this.setOperationBody(constructor, "\n        super(parameter);\n    ");
    }
}

