/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContext;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;
import org.nuiton.topia.persistence.jdbc.JdbcHelper;
import org.nuiton.topia.persistence.support.TopiaSqlWork;
import org.nuiton.topia.service.sql.batch.actions.AbstractSqlRequest;
import org.nuiton.util.TimeLog;

public abstract class AbstractSqlAction<R extends AbstractSqlRequest>
implements Runnable,
Closeable {
    protected static final TimeLog TIME_LOG = new TimeLog(AbstractSqlAction.class, 50L, 100L);
    private static final Log log = LogFactory.getLog(AbstractSqlAction.class);
    protected final R request;
    protected final ImmutableSet<Closeable> closeables;
    protected TopiaPersistenceContext sourcePersistenceContext;
    protected Connection targetConnection;
    protected Writer writer;
    protected long startTime;
    protected long endTime;

    protected AbstractSqlAction(R request) {
        this.request = request;
        ImmutableSet.Builder closeableBuilder = ImmutableSet.builder();
        closeableBuilder.add((Object)new Closeable(){

            @Override
            public void close() throws IOException {
                if (AbstractSqlAction.this.sourcePersistenceContext != null) {
                    AbstractSqlAction.this.sourcePersistenceContext.close();
                }
            }
        });
        closeableBuilder.add((Object)new Closeable(){

            @Override
            public void close() throws IOException {
                if (AbstractSqlAction.this.targetConnection != null) {
                    try {
                        AbstractSqlAction.this.targetConnection.close();
                    }
                    catch (SQLException e) {
                        throw new TopiaException("Could not close targetConnection", (Throwable)e);
                    }
                }
            }
        });
        this.closeables = closeableBuilder.build();
    }

    protected static void flush(Writer writer) {
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new TopiaException("Could not flush writer", (Throwable)e);
        }
    }

    public R getRequest() {
        return this.request;
    }

    protected boolean useOutputWriter() {
        return ((AbstractSqlRequest)this.request).getWriter() != null;
    }

    protected boolean useOutputDb() {
        return ((AbstractSqlRequest)this.request).getTargetTopiaApplicationContext() != null;
    }

    protected abstract void execute() throws IOException, SQLException;

    @Override
    public final void run() {
        try {
            this.before();
            this.execute();
            this.after();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void commit() {
        if (this.useOutputWriter()) {
            AbstractSqlAction.flush(this.writer);
        }
        if (this.useOutputDb() && this.targetConnection != null) {
            try {
                this.targetConnection.commit();
            }
            catch (SQLException e) {
                throw new TopiaException("Could not commit", (Throwable)e);
            }
        }
    }

    @Override
    public final void close() {
        Exception error = null;
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                error = e;
                log.error((Object)"Could not close", (Throwable)e);
            }
        }
        if (error != null) {
            throw new RuntimeException("Could not close", error);
        }
    }

    protected final void before() throws SQLException {
        this.startTime = TimeLog.getTime();
        if (this.useOutputWriter()) {
            this.writer = ((AbstractSqlRequest)this.request).getWriter();
        }
        if (this.useOutputDb()) {
            OpenJdbcHelper jdbcHelper = new OpenJdbcHelper((JdbcConfiguration)((AbstractSqlRequest)this.request).getTargetTopiaApplicationContext().getConfiguration());
            this.targetConnection = jdbcHelper.openConnection();
        }
    }

    protected void fail(Exception e) {
        this.endTime = TIME_LOG.log(this.startTime, "Action failed", this.getClass().getName());
        throw new TopiaException((Throwable)e);
    }

    protected final void after() throws SQLException {
        this.endTime = TIME_LOG.log(this.startTime, "Action executed", this.getClass().getName());
    }

    protected void executeSqlWork(TopiaSqlWork sqlWork) {
        this.getSourcePersistenceContext().getSqlSupport().doSqlWork(sqlWork);
    }

    protected AbstractTopiaPersistenceContext getSourcePersistenceContext() {
        if (this.sourcePersistenceContext == null) {
            this.sourcePersistenceContext = ((AbstractSqlRequest)this.request).getSourceTopiaApplicationContext().newPersistenceContext();
        }
        return (AbstractTopiaPersistenceContext)this.sourcePersistenceContext;
    }

    protected ImmutableSet<String> getSchemaNames() {
        TopiaApplicationContext sourceTopiaApplicationContext = ((AbstractSqlRequest)this.request).getSourceTopiaApplicationContext();
        return sourceTopiaApplicationContext.getSchemaNames();
    }

    protected static class OpenJdbcHelper
    extends JdbcHelper {
        public OpenJdbcHelper(JdbcConfiguration jdbcConfiguration) {
            super(jdbcConfiguration);
        }

        public Connection openConnection() throws SQLException {
            return super.openConnection();
        }
    }
}

