/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.nuiton.topia.service.sql.batch.actions.AbstractSqlRequest;

public abstract class AbstractSchemaRequest
extends AbstractSqlRequest {
    protected Class<? extends Dialect> dialect;
    protected Path temporaryPath;

    public Class<? extends Dialect> getDialect() {
        return this.dialect;
    }

    protected void setDialect(Class<? extends Dialect> dialect) {
        this.dialect = dialect;
    }

    public Path getTemporaryPath() {
        return this.temporaryPath;
    }

    protected void setTemporaryPath(Path temporaryPath) {
        this.temporaryPath = temporaryPath;
    }

    public static abstract class AbstractSchemaRequestBuilder<R extends AbstractSchemaRequest, B extends AbstractSchemaRequestBuilder<R, B>>
    extends AbstractSqlRequest.AbstractSqlRequestBuilder<B, R> {
        protected AbstractSchemaRequestBuilder(R request) {
            super(request);
        }

        public B forH2() {
            this.setDialect(H2Dialect.class);
            return (B)((AbstractSchemaRequestBuilder)this.returnThis());
        }

        public B forPostgres() {
            this.setDialect(PostgreSQL9Dialect.class);
            return (B)((AbstractSchemaRequestBuilder)this.returnThis());
        }

        public B setDialect(Class<? extends Dialect> dialectType) {
            ((AbstractSchemaRequest)this.request).setDialect(dialectType);
            return (B)((AbstractSchemaRequestBuilder)this.returnThis());
        }

        public B setTemporaryPath(Path temporaryPath) {
            ((AbstractSchemaRequest)this.request).setTemporaryPath(temporaryPath);
            return (B)((AbstractSchemaRequestBuilder)this.returnThis());
        }

        @Override
        protected void checkParams() {
            super.checkParams();
            Preconditions.checkState((((AbstractSchemaRequest)this.request).getDialect() != null ? 1 : 0) != 0, (Object)"No dialect defined");
            if (((AbstractSchemaRequest)this.request).getTemporaryPath() == null) {
                try {
                    Path tempDirectory = Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]);
                    this.setTemporaryPath(tempDirectory);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not create teomporary path");
                }
            }
        }
    }
}

