package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Thu Oct 31 23:55:04 CET 2013")
public abstract class TaasPrincipalAbstract extends TopiaEntityAbstract implements TaasPrincipal {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : authorizations
     */
    protected Collection<TaasAuthorization> authorizations;

    private static final long serialVersionUID = 3761973761041260899L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, AUTHORIZATIONS, Collection.class, TaasAuthorization.class, authorizations);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
    }

    @Override
    public void addAuthorizations(TaasAuthorization authorizations) {
        fireOnPreWrite(AUTHORIZATIONS, null, authorizations);
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<TaasAuthorization>();
        }

        this.authorizations.add(authorizations);
        fireOnPostWrite(AUTHORIZATIONS, this.authorizations.size(), null, authorizations);
    }

    @Override
    public void addAllAuthorizations(Collection<TaasAuthorization> authorizations) {
        if (authorizations == null) {
            return;
        }
        for (TaasAuthorization item : authorizations) {
            addAuthorizations(item);
        }
    }

    @Override
    public void setAuthorizations(Collection<TaasAuthorization> authorizations) {
        // Copy elements to keep data for fire with new reference
        Collection<TaasAuthorization> oldValue = this.authorizations != null ? new ArrayList<TaasAuthorization>(this.authorizations) : null;
        fireOnPreWrite(AUTHORIZATIONS, oldValue, authorizations);
        this.authorizations = authorizations;
        fireOnPostWrite(AUTHORIZATIONS, oldValue, authorizations);
    }

    @Override
    public void removeAuthorizations(TaasAuthorization authorizations) {
        fireOnPreWrite(AUTHORIZATIONS, authorizations, null);
        if (this.authorizations == null || !this.authorizations.remove(authorizations)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(AUTHORIZATIONS, this.authorizations.size() + 1, authorizations, null);
    }

    @Override
    public void clearAuthorizations() {
        if (this.authorizations == null) {
            return;
        }
        Collection<TaasAuthorization> oldValue = new ArrayList<TaasAuthorization>(this.authorizations);
        fireOnPreWrite(AUTHORIZATIONS, oldValue, this.authorizations);
        this.authorizations.clear();
        fireOnPostWrite(AUTHORIZATIONS, oldValue, this.authorizations);
    }

    @Override
    public Collection<TaasAuthorization> getAuthorizations() {
        return authorizations;
    }

    @Override
    public TaasAuthorization getAuthorizationsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(authorizations, topiaId);
    }

    @Override
    public int sizeAuthorizations() {
        if (authorizations == null) {
            return 0;
        }
        return authorizations.size();
    }

    @Override
    public boolean isAuthorizationsEmpty() {
        int size = sizeAuthorizations();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(AUTHORIZATIONS, this.authorizations).
         toString();
        return result;
    }

} //TaasPrincipalAbstract
