package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TopiaGroupDAOAbstract<E extends TopiaGroup> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaGroup.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<org.nuiton.topia.security.entities.user.TopiaUser> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from topiaUser main, topiagroup_topiauser secondary " +
                    "where main.topiaid=secondary.topiaUser" +
                    " and secondary.topiaGroup='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(org.nuiton.topia.security.entities.user.TopiaUser.class)).list();
            for (org.nuiton.topia.security.entities.user.TopiaUser item : list) {
                item.removeTopiaGroup(entity);
            }
        }

                {
                List<TopiaGroup> list = getContext()
                            .getDAO(TopiaGroup.class)
                            .findAllByProperties(TopiaGroup.SUPER_GROUP, entity);
//                            .findAllByProperties("superGroup", entity);
                    for (TopiaGroup item : list) {
                        item.setSuperGroup(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(TopiaGroup.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.NAME, v);
        return result;
    }

    /**
     * findByDescription :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut description le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByDescription(String v) throws TopiaException {
        E result = findByProperty(TopiaGroup.DESCRIPTION, v);
        return result;
    }

    /**
     * findAllByDescription :
     * Retourne les éléments ayant comme valeur pour l'attribut description le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByDescription(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.DESCRIPTION, v);
        return result;
    }

    /**
     * findContainsTopiaUser :
     * Retourne le premier élément trouvé dont l'attribut topiaUser contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsTopiaUser(TopiaUser... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(TopiaGroup.TOPIA_USER, Arrays.asList(v));
        E result = findContainsProperties("topiaUser", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsTopiaUser :
     * Retourne les éléments trouvé dont l'attribut topiaUser contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsTopiaUser(TopiaUser... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(TopiaGroup.TOPIA_USER, Arrays.asList(v));
        List<E> results = findAllContainsProperties("topiaUser", Arrays.asList(v));
        return results;
    }

    /**
     * findBySuperGroup :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut superGroup le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySuperGroup(TopiaGroup v) throws TopiaException {
        E result = findByProperty(TopiaGroup.SUPER_GROUP, v);
        return result;
    }

    /**
     * findAllBySuperGroup :
     * Retourne les éléments ayant comme valeur pour l'attribut superGroup le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySuperGroup(TopiaGroup v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.SUPER_GROUP, v);
        return result;
    }

    /**
     * findContainsSubGroup :
     * Retourne le premier élément trouvé dont l'attribut subGroup contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSubGroup(TopiaGroup... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(TopiaGroup.SUB_GROUP, Arrays.asList(v));
        E result = findContainsProperties("subGroup", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsSubGroup :
     * Retourne les éléments trouvé dont l'attribut subGroup contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSubGroup(TopiaGroup... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(TopiaGroup.SUB_GROUP, Arrays.asList(v));
        List<E> results = findAllContainsProperties("subGroup", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == TopiaUser.class) {
            TopiaUserDAO dao = (TopiaUserDAO)
                getContext().getDAO(TopiaUser.class);
            tmp = dao.findAllContainsTopiaGroup(entity);
//            tmp = dao.findAllByProperties(TopiaUser.TOPIA_GROUP, entity);
            result.addAll(tmp);
        }

        if (type == TopiaGroup.class) {
            TopiaGroupDAO dao = (TopiaGroupDAO)
                getContext().getDAO(TopiaGroup.class);
            tmp = dao.findAllBySuperGroup(entity);
//            tmp = dao.findAllByProperties(TopiaGroup.SUPER_GROUP, entity);
            result.addAll(tmp);
        }

        if (type == TopiaGroup.class) {
            TopiaGroupDAO dao = (TopiaGroupDAO)
                getContext().getDAO(TopiaGroup.class);
            tmp = dao.findAllContainsSubGroup(entity);
//            tmp = dao.findAllByProperties(TopiaGroup.SUB_GROUP, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<?>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<?>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<?>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<?>, List<? extends TopiaEntity>>(2);
        
        List<? extends TopiaEntity> list;

        list = findUsages(TopiaUser.class, entity);
        if (!list.isEmpty()) {
            result.put(TopiaUser.class, list);
        }

        list = findUsages(TopiaGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(TopiaGroup.class, list);
        }

        return result;
    }


} //TopiaGroupDAOAbstract<E extends TopiaGroup>
