package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.security.entities.authorization.TopiaAssociationAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaAssociationAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorization;
import org.nuiton.topia.security.entities.authorization.TopiaEntityAuthorizationDAO;
import org.nuiton.topia.security.entities.authorization.TopiaExpressionLink;
import org.nuiton.topia.security.entities.authorization.TopiaExpressionLinkDAO;
import org.nuiton.topia.security.entities.user.TopiaGroup;
import org.nuiton.topia.security.entities.user.TopiaGroupDAO;
import org.nuiton.topia.security.entities.user.TopiaUser;
import org.nuiton.topia.security.entities.user.TopiaUserDAO;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasAuthorizationDAO;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;


public class TopiaSecurityDAOHelper {



    public enum TopiaSecurityEntityEnum implements TopiaEntityEnum {

        TopiaAssociationAuthorization(TopiaAssociationAuthorization.class),
        TopiaAuthorization(TopiaAuthorization.class),
        TopiaEntityAuthorization(TopiaEntityAuthorization.class),
        TopiaExpressionLink(TopiaExpressionLink.class),
        TopiaGroup(TopiaGroup.class),
        TopiaUser(TopiaUser.class),
        TaasAuthorization(TaasAuthorization.class),
        TaasPrincipal(TaasPrincipal.class),
        TaasUser(TaasUser.class);
        /**
         * the contract of the entity
         */
        protected Class<? extends TopiaEntity> contract;
        /**
         * the fully qualified name of the implementation of the entity
         */
        protected String implementationFQN;
        /**
         * the implementation class of the entity (will be lazy computed at runtime)
         */
        protected Class<? extends TopiaEntity> implementation;
        /**
         * TopiaSecurityEntityEnum :
             * @param contract 
     */

         TopiaSecurityEntityEnum(Class<? extends TopiaEntity > contract)     {
        this.contract = contract;
        this.implementationFQN = contract.getName()+"Impl";
        }

        /**
         * getContract :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        /**
         * getImplementationFQN :
             * @return String 
     */

        public String getImplementationFQN()     {
        return implementationFQN;
        }

        /**
         * setImplementationFQN :
             * @param implementationFQN 
     */

        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        /**
         * accept :
             * @param klass 
         * @return boolean 
     */

        public boolean accept(Class<? extends TopiaEntity> klass)     {
         return TopiaSecurityDAOHelper.getContractClass(klass) == contract;
         }

        /**
         * getImplementation :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getImplementation()     {
         if (implementation == null) {
            try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
         }
         return implementation;
         }

        /**
         * valueOf :
             * @param entity 
         * @return TopiaSecurityEntityEnum 
     */

        public static TopiaSecurityEntityEnum valueOf(TopiaEntity entity)     {
         return valueOf(entity.getClass());
         }

        /**
         * valueOf :
             * @param klass 
         * @return TopiaSecurityEntityEnum 
     */

        public static TopiaSecurityEntityEnum valueOf(Class<?> klass)     {
         if (klass.isInterface()) {
            return TopiaSecurityEntityEnum.valueOf(klass.getSimpleName());
         }
         for (TopiaSecurityEntityEnum entityEnum : TopiaSecurityEntityEnum.values()) {
             if (entityEnum.getContract().isAssignableFrom(klass)) {
                 //todo check it works for inheritance
                 return entityEnum;
             }
         }
         throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(TopiaSecurityEntityEnum.values()));
         }


    } //TopiaSecurityEntityEnum
        /**
         * TopiaSecurityDAOHelper :
         */

        protected TopiaSecurityDAOHelper()     {     }

        /**
         * getModelVersion :
             * @return String 
     */

        public static String getModelVersion()     {
        return "1";
        }

        /**
         * getTopiaAssociationAuthorizationDAO :
             * @param context 
         * @return TopiaAssociationAuthorizationDAO 
         * @throws TopiaException
     */

        public static TopiaAssociationAuthorizationDAO getTopiaAssociationAuthorizationDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaAssociationAuthorizationDAO result = (TopiaAssociationAuthorizationDAO) ci.getDAO(TopiaAssociationAuthorization.class);
        return result;
        }

        /**
         * getTopiaAuthorizationDAO :
             * @param context 
         * @return TopiaAuthorizationDAO 
         * @throws TopiaException
     */

        public static TopiaAuthorizationDAO getTopiaAuthorizationDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaAuthorizationDAO result = (TopiaAuthorizationDAO) ci.getDAO(TopiaAuthorization.class);
        return result;
        }

        /**
         * getTopiaEntityAuthorizationDAO :
             * @param context 
         * @return TopiaEntityAuthorizationDAO 
         * @throws TopiaException
     */

        public static TopiaEntityAuthorizationDAO getTopiaEntityAuthorizationDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaEntityAuthorizationDAO result = (TopiaEntityAuthorizationDAO) ci.getDAO(TopiaEntityAuthorization.class);
        return result;
        }

        /**
         * getTopiaExpressionLinkDAO :
             * @param context 
         * @return TopiaExpressionLinkDAO 
         * @throws TopiaException
     */

        public static TopiaExpressionLinkDAO getTopiaExpressionLinkDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaExpressionLinkDAO result = (TopiaExpressionLinkDAO) ci.getDAO(TopiaExpressionLink.class);
        return result;
        }

        /**
         * getTopiaGroupDAO :
             * @param context 
         * @return TopiaGroupDAO 
         * @throws TopiaException
     */

        public static TopiaGroupDAO getTopiaGroupDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaGroupDAO result = (TopiaGroupDAO) ci.getDAO(TopiaGroup.class);
        return result;
        }

        /**
         * getTopiaUserDAO :
             * @param context 
         * @return TopiaUserDAO 
         * @throws TopiaException
     */

        public static TopiaUserDAO getTopiaUserDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaUserDAO result = (TopiaUserDAO) ci.getDAO(TopiaUser.class);
        return result;
        }

        /**
         * getTaasAuthorizationDAO :
             * @param context 
         * @return TaasAuthorizationDAO 
         * @throws TopiaException
     */

        public static TaasAuthorizationDAO getTaasAuthorizationDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasAuthorizationDAO result = (TaasAuthorizationDAO) ci.getDAO(TaasAuthorization.class);
        return result;
        }

        /**
         * getTaasPrincipalDAO :
             * @param context 
         * @return TaasPrincipalDAO 
         * @throws TopiaException
     */

        public static TaasPrincipalDAO getTaasPrincipalDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasPrincipalDAO result = (TaasPrincipalDAO) ci.getDAO(TaasPrincipal.class);
        return result;
        }

        /**
         * getTaasUserDAO :
             * @param context 
         * @return TaasUserDAO 
         * @throws TopiaException
     */

        public static TaasUserDAO getTaasUserDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasUserDAO result = (TaasUserDAO) ci.getDAO(TaasUser.class);
        return result;
        }

        /**
         * getDAO :
             * @param context 
         * @param klass 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getDAO :
             * @param context 
         * @param entity 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getContractClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass)     {
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
        }

        /**
         * getImplementationClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass)     {
        TopiaSecurityEntityEnum constant = TopiaSecurityEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
        }

        /**
         * getContractClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getContractClasses()     {
        TopiaSecurityEntityEnum[] values = TopiaSecurityEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
        }

        /**
         * getImplementationClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getImplementationClasses()     {
        TopiaSecurityEntityEnum[] values = TopiaSecurityEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
        }

        /**
         * getImplementationClassesAsString :
             * @return String 
     */

        public static String getImplementationClassesAsString()     {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
        }

        /**
         * getContracts :
             * @return TopiaSecurityEntityEnum[] 
     */

        public static TopiaSecurityEntityEnum[] getContracts()     {
        return TopiaSecurityEntityEnum.values();
        }


    } //TopiaSecurityDAOHelper
