/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasPrincipal;

public abstract class TaasPrincipalAbstract
extends TopiaEntityAbstract
implements TaasPrincipal {
    protected String name;
    public Collection<TaasAuthorization> authorizations;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(TaasPrincipal.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(TaasPrincipal.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "authorizations", Collection.class, TaasAuthorization.class, this.authorizations);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        this.fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        this.fireOnPostWrite("name", _oldValue, value);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void addAuthorizations(TaasAuthorization authorizations) {
        this.fireOnPreWrite("authorizations", null, authorizations);
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<TaasAuthorization>();
        }
        this.authorizations.add(authorizations);
        this.fireOnPostWrite("authorizations", this.authorizations.size(), null, authorizations);
    }

    @Override
    public void addAllAuthorizations(Collection<TaasAuthorization> values) {
        if (values == null) {
            return;
        }
        for (TaasAuthorization item : values) {
            this.addAuthorizations(item);
        }
    }

    @Override
    public TaasAuthorization getAuthorizationsByTopiaId(String topiaId) {
        return (TaasAuthorization)TopiaEntityHelper.getEntityByTopiaId(this.authorizations, (String)topiaId);
    }

    @Override
    public void setAuthorizations(Collection<TaasAuthorization> values) {
        Collection<TaasAuthorization> _oldValue = this.authorizations;
        this.fireOnPreWrite("authorizations", _oldValue, values);
        this.authorizations = values;
        this.fireOnPostWrite("authorizations", _oldValue, values);
    }

    @Override
    public void removeAuthorizations(TaasAuthorization value) {
        this.fireOnPreWrite("authorizations", value, null);
        if (this.authorizations == null || !this.authorizations.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("authorizations", this.authorizations.size() + 1, value, null);
    }

    @Override
    public void clearAuthorizations() {
        if (this.authorizations == null) {
            return;
        }
        ArrayList<TaasAuthorization> _oldValue = new ArrayList<TaasAuthorization>(this.authorizations);
        this.fireOnPreWrite("authorizations", _oldValue, this.authorizations);
        this.authorizations.clear();
        this.fireOnPostWrite("authorizations", _oldValue, this.authorizations);
    }

    @Override
    public Collection<TaasAuthorization> getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public int sizeAuthorizations() {
        if (this.authorizations == null) {
            return 0;
        }
        return this.authorizations.size();
    }

    @Override
    public boolean isAuthorizationsEmpty() {
        int size = this.sizeAuthorizations();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("authorizations", this.authorizations).toString();
        return result;
    }
}

