/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * TopiaService.java
 *
 * Created: 8 oct. 06 17:15:52
 *
 * @author poussin
 * @version $Revision: 1558 $
 *
 * Last update: $Date: 2009-06-11 06:53:44 +0200 (jeu. 11 juin 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.framework;

/**
 * Permet d'implanter un service Topia. Il faut absolument créer une interface
 * pour votre service qui contienne un attribut SERVICE_NAME
 * 
 * <li>public static final String SERVICE_NAME = "monservice";
 * 
 * la valeur de cette attribut doit être retourné par les implantation de votre
 * service par la méthode {@link #getServiceName()}
 * 
 * @author poussin
 */
public interface TopiaService {

    /**
     * Retourne le nom du service, ce nom doit correspondre a ce qui est
     * trouvé dans le fichier de configuration, par exemple pour le service
     * d'indexation on doit avoir: topia.service.index et cette methode doit
     * retourner index
     * 
     * @return
     */
    public String getServiceName();

    /**
     * Permet de récupérer les entités à persister pour ce service
     * @return Liste des entités à persister, séparées par des virgules
     */
    public Class<?>[] getPersistenceClasses();

    /**
     * Initialise le service avant de creer le context
     * @param context le context
     * @return si le service doit etre laissé activé ou pas
     */
    public boolean preInit(TopiaContextImplementor context);

    /**
     * Initialise le service apres avoir creer le context
     * @param context le context
     * @return si le service doit etre laissé activé ou pas
     */
    public boolean postInit(TopiaContextImplementor context);

}
