package org.nuiton.topia.it.legacy.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyDao;
import org.nuiton.topia.it.legacy.TopiaItLegacyEntityEnum;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Wed Jul 30 13:09:22 CEST 2014")
public abstract class GeneratedAddressTopiaDao<E extends Address> extends AbstractTopiaItLegacyDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Address.class;
    }

    @Override
    public TopiaItLegacyEntityEnum getTopiaEntityEnum() {
        return TopiaItLegacyEntityEnum.Address;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PersonneTopiaDao dao = topiaDaoSupplier
                    .getDao(Personne.class, PersonneTopiaDao.class);
            List<Personne> list = dao
                    .forProperties(Personne.PROPERTY_ADDRESS, entity)
                    .findAll();
            for (Personne item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getAddress())) {
                    item.setAddress(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCityIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Address.PROPERTY_CITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCityEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Address.PROPERTY_CITY, v);
        return result;
    }

    @Deprecated
    public E findByCity(String v) {
        return forCityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCity(String v) {
        return forCityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAdressIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Address.PROPERTY_ADRESS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAdressEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Address.PROPERTY_ADRESS, v);
        return result;
    }

    @Deprecated
    public E findByAdress(String v) {
        return forAdressEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAdress(String v) {
        return forAdressEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Personne.class) {
            PersonneTopiaDao dao =
                topiaDaoSupplier.getDao(Personne.class, PersonneTopiaDao.class);
            tmp = dao.forAddressEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Personne.class, entity);
        if (!list.isEmpty()) {
            result.put(Personne.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAddressTopiaDao<E extends Address>
