/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rtextarea.RegExReplaceInfo;

public class SearchEngine {
    private SearchEngine() {
    }

    public static boolean find(JTextArea jTextArea, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        Caret caret = jTextArea.getCaret();
        int n = bl ? Math.max(caret.getDot(), caret.getMark()) : Math.min(caret.getDot(), caret.getMark());
        String string2 = SearchEngine.getFindInText(jTextArea, n, bl);
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (!bl4) {
            int n2 = SearchEngine.getNextMatchPos(string, string2, bl, bl2, bl3);
            string2 = null;
            if (n2 != -1) {
                caret.setSelectionVisible(true);
                n2 = bl ? n + n2 : n2;
                caret.setDot(n2);
                caret.moveDot(n2 + string.length());
                return true;
            }
        } else {
            Point point = SearchEngine.getNextMatchPosRegEx(string, string2, bl, bl2, bl3);
            string2 = null;
            if (point != null) {
                caret.setSelectionVisible(true);
                if (bl) {
                    point.translate(n, n);
                }
                caret.setDot(point.x);
                caret.moveDot(point.y);
                return true;
            }
        }
        return false;
    }

    protected static String getFindInText(JTextArea jTextArea, int n, boolean bl) {
        String string = null;
        if (bl) {
            try {
                string = jTextArea.getText(n, jTextArea.getDocument().getLength() - n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            try {
                string = jTextArea.getText(0, n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return string;
    }

    protected static List getMatches(Matcher matcher, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (matcher.find()) {
            Point point = new Point(matcher.start(), matcher.end());
            if (string == null) {
                arrayList.add(point);
                continue;
            }
            arrayList.add(new RegExReplaceInfo(matcher.group(0), point.x, point.y, SearchEngine.getReplacementText(matcher, string)));
        }
        return arrayList;
    }

    public static final int getNextMatchPos(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl2) {
            return SearchEngine.getNextMatchPosImpl(string.toLowerCase(), string2.toLowerCase(), bl, bl2, bl3);
        }
        return SearchEngine.getNextMatchPosImpl(string, string2, bl, bl2, bl3);
    }

    protected static final int getNextMatchPosImpl(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            int n = string.length();
            int n2 = bl ? 0 : string2.length();
            int n3 = bl ? 1 : -1;
            while ((n2 = bl ? string2.indexOf(string, n2) : string2.lastIndexOf(string, n2)) != -1) {
                if (SearchEngine.isWholeWord(string2, n2, n)) {
                    return n2;
                }
                n2 += n3;
            }
            return n2;
        }
        return bl ? string2.indexOf(string) : string2.lastIndexOf(string);
    }

    public static Point getNextMatchPosRegEx(String string, CharSequence charSequence, boolean bl, boolean bl2, boolean bl3) {
        return (Point)SearchEngine.getNextMatchPosRegExImpl(string, charSequence, bl, bl2, bl3, null);
    }

    protected static Object getNextMatchPosRegExImpl(String string, CharSequence charSequence, boolean bl, boolean bl2, boolean bl3, String string2) {
        int n = 8;
        Pattern pattern = Pattern.compile(string, n |= bl2 ? 0 : 66);
        Matcher matcher = pattern.matcher(charSequence);
        if (bl) {
            if (!bl3) {
                if (matcher.find()) {
                    if (string2 == null) {
                        return new Point(matcher.start(), matcher.end());
                    }
                    return new RegExReplaceInfo(matcher.group(0), matcher.start(), matcher.end(), SearchEngine.getReplacementText(matcher, string2));
                }
            } else {
                while (matcher.find()) {
                    Point point = new Point(matcher.start(), matcher.end());
                    if (!SearchEngine.isWholeWord(charSequence, point.x, point.y - point.x)) continue;
                    if (string2 == null) {
                        return point;
                    }
                    return new RegExReplaceInfo(matcher.group(0), point.x, point.y, SearchEngine.getReplacementText(matcher, string2));
                }
            }
        } else {
            int n2;
            List list = SearchEngine.getMatches(matcher, string2);
            if (list.isEmpty()) {
                return null;
            }
            if (!bl3) {
                if (string2 == null) {
                    return list.get(n2);
                }
                return list.get(n2);
            }
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                int n3;
                Object object;
                Object e = list.get(n2);
                if (string2 == null) {
                    object = (Point)e;
                    if (!SearchEngine.isWholeWord(charSequence, ((Point)object).x, ((Point)object).y - ((Point)object).x)) continue;
                    return e;
                }
                object = (RegExReplaceInfo)e;
                int n4 = ((RegExReplaceInfo)object).getStartIndex();
                if (!SearchEngine.isWholeWord(charSequence, n4, (n3 = ((RegExReplaceInfo)object).getEndIndex()) - n4)) continue;
                return e;
            }
        }
        return null;
    }

    protected static RegExReplaceInfo getRegExReplaceInfo(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        return (RegExReplaceInfo)SearchEngine.getNextMatchPosRegExImpl(string, string2, bl, bl2, bl3, string3);
    }

    public static String getReplacementText(Matcher matcher, CharSequence charSequence) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            if (c == '\\') {
                c = charSequence.charAt(++n);
                switch (c) {
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 't': {
                        c = '\t';
                    }
                }
                stringBuffer.append(c);
                ++n;
                continue;
            }
            if (c == '$') {
                int n2;
                int n3;
                if ((n3 = charSequence.charAt(++n) - 48) < 0 || n3 > 9) {
                    throw new IndexOutOfBoundsException("No group " + charSequence.charAt(n));
                }
                ++n;
                boolean bl = false;
                while (!bl && n < charSequence.length() && (n2 = charSequence.charAt(n) - 48) >= 0 && n2 <= 9) {
                    int n4 = n3 * 10 + n2;
                    if (matcher.groupCount() < n4) {
                        bl = true;
                        continue;
                    }
                    n3 = n4;
                    ++n;
                }
                if (matcher.group(n3) == null) continue;
                stringBuffer.append(matcher.group(n3));
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final boolean isWholeWord(CharSequence charSequence, int n, int n2) {
        boolean bl;
        boolean bl2;
        try {
            bl2 = Character.isWhitespace(charSequence.charAt(n - 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl2 = true;
        }
        try {
            bl = Character.isWhitespace(charSequence.charAt(n + n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = true;
        }
        return bl2 && bl;
    }

    protected static int makeMarkAndDotEqual(JTextArea jTextArea, boolean bl) {
        Caret caret = jTextArea.getCaret();
        int n = bl ? Math.min(caret.getDot(), caret.getMark()) : Math.max(caret.getDot(), caret.getMark());
        caret.setDot(n);
        return n;
    }

    protected static boolean regexReplace(JTextArea jTextArea, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws PatternSyntaxException {
        Caret caret = jTextArea.getCaret();
        int n = SearchEngine.makeMarkAndDotEqual(jTextArea, bl);
        String string3 = SearchEngine.getFindInText(jTextArea, n, bl);
        if (string3 == null) {
            return false;
        }
        RegExReplaceInfo regExReplaceInfo = SearchEngine.getRegExReplaceInfo(string, string3, bl, bl2, bl3, string2);
        string3 = null;
        if (regExReplaceInfo != null) {
            caret.setSelectionVisible(true);
            int n2 = regExReplaceInfo.getStartIndex();
            int n3 = regExReplaceInfo.getEndIndex();
            if (bl) {
                n2 += n;
                n3 += n;
            }
            caret.setDot(n2);
            caret.moveDot(n3);
            jTextArea.replaceSelection(regExReplaceInfo.getReplacement());
            return true;
        }
        return false;
    }

    public static boolean replace(JTextArea jTextArea, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        if (bl4) {
            return SearchEngine.regexReplace(jTextArea, string, string2, bl, bl2, bl3);
        }
        SearchEngine.makeMarkAndDotEqual(jTextArea, bl);
        if (SearchEngine.find(jTextArea, string, bl, bl2, bl3, false)) {
            jTextArea.replaceSelection(string2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int replaceAll(JTextArea jTextArea, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws PatternSyntaxException {
        int n = 0;
        if (bl3) {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = jTextArea.getText();
            int n2 = 0;
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(string3);
            try {
                while (matcher.find()) {
                    stringBuffer.append(string3.substring(n2, matcher.start()));
                    stringBuffer.append(SearchEngine.getReplacementText(matcher, string2));
                    n2 = matcher.end();
                    ++n;
                }
                stringBuffer.append(string3.substring(n2));
                jTextArea.setText(stringBuffer.toString());
            }
            finally {
                string3 = null;
            }
        } else {
            jTextArea.setCaretPosition(0);
            while (SearchEngine.find(jTextArea, string, true, bl, bl2, false)) {
                jTextArea.replaceSelection(string2);
                ++n;
            }
        }
        return n;
    }
}

