/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRI;

import java.util.Vector;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RVector;

public class RList {
    public REXP head;
    public REXP body;
    public REXP tag;
    String[] keys = null;
    REXP[] values = null;
    boolean dirtyCache = true;

    public RList() {
        this.tag = null;
        this.body = null;
        this.head = null;
    }

    public RList(RVector v) {
        Vector n = v.getNames();
        if (n != null) {
            this.keys = new String[n.size()];
            n.copyInto(this.keys);
        }
        this.values = new REXP[v.size()];
        v.copyInto(this.values);
        this.dirtyCache = false;
    }

    public RList(REXP h, REXP b) {
        this.head = h;
        this.body = b;
        this.tag = null;
    }

    public RList(REXP h, REXP t, REXP b) {
        this.head = h;
        this.body = b;
        this.tag = t;
    }

    public REXP getHead() {
        return this.head;
    }

    public REXP getBody() {
        return this.body;
    }

    public REXP getTag() {
        return this.tag;
    }

    boolean updateVec() {
        if (!this.dirtyCache) {
            return true;
        }
        RList cur = this;
        int l = 0;
        while (cur != null) {
            ++l;
            REXP bd = cur.getBody();
            cur = bd == null ? null : bd.asList();
        }
        this.keys = new String[l];
        this.values = new REXP[l];
        cur = this;
        l = 0;
        while (cur != null) {
            REXP x = cur.getTag();
            if (x != null) {
                this.keys[l] = x.asSymbolName();
            }
            this.values[l] = cur.getHead();
            REXP bd = cur.getBody();
            cur = bd == null ? null : bd.asList();
            ++l;
        }
        this.dirtyCache = false;
        return true;
    }

    public REXP at(String v) {
        if (!this.updateVec() || this.keys == null || this.values == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i].compareTo(v) != 0) continue;
            return this.values[i];
        }
        return null;
    }

    public REXP at(int i) {
        return !this.updateVec() || this.values == null || i < 0 || i >= this.values.length ? null : this.values[i];
    }

    public String[] keys() {
        return !this.updateVec() ? null : this.keys;
    }
}

