/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.svn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.api.ScmFileManager;
import org.nuiton.scmwebeditor.api.dto.CreateDirectoryDto;
import org.nuiton.scmwebeditor.api.dto.MoveFileDto;
import org.nuiton.scmwebeditor.api.dto.RemoveDirectoryDto;
import org.nuiton.scmwebeditor.api.dto.RemoveFileDto;
import org.nuiton.scmwebeditor.api.dto.UploadFileDto;
import org.nuiton.scmwebeditor.api.dto.result.CreateDirectoryResultDto;
import org.nuiton.scmwebeditor.api.dto.result.MoveFileResultDto;
import org.nuiton.scmwebeditor.api.dto.result.RemoveDirectoryResultDto;
import org.nuiton.scmwebeditor.api.dto.result.RemoveFileResultDto;
import org.nuiton.scmwebeditor.api.dto.result.UploadFileResultDto;
import org.nuiton.scmwebeditor.svn.SvnConnection;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnFileManager
implements ScmFileManager {
    private static final Log log = LogFactory.getLog(SvnFileManager.class);
    SvnConnection connection;

    public SvnFileManager(SvnConnection connection) throws SVNException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SVN repository");
        }
        this.connection = connection;
    }

    public UploadFileResultDto uploadFile(UploadFileDto dto) {
        UploadFileResultDto resultDto = new UploadFileResultDto();
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        resultDto.setScmRoot(this.connection.getSvnRoot(dto.getUsername(), dto.getPassword()));
        if (resultDto.getScmRoot() == null) {
            resultDto.setScmRoot(this.connection.getSvnPath());
        }
        if (this.connection.getSvnPath().endsWith("/")) {
            resultDto.setFileRoot(this.connection.getSvnPath().substring(0, this.connection.getSvnPath().lastIndexOf(47)));
        } else {
            resultDto.setFileRoot(this.connection.getSvnPath());
        }
        this.connection.updateAuthentication(dto.getUsername(), dto.getPassword());
        try {
            this.connection.testConnection();
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Test connection fail", (Throwable)e);
            }
            resultDto.setError("connection failed");
            return resultDto;
        }
        if (dto.getUpload() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("FileName : " + dto.getUploadFileName()));
            log.debug((Object)("ContentType : " + dto.getUploadContentType()));
        }
        SVNCommitClient commitClient = new SVNCommitClient((ISVNRepositoryPool)this.connection.getManager(), (ISVNOptions)this.connection.getSvnOption());
        try {
            commitClient.doImport(dto.getUpload(), SVNURL.parseURIEncoded((String)(dto.getScmPath() + "/" + dto.getUploadFileName())), "From scmwebeditor -- add the file : " + dto.getUploadFileName(), null, false, false, SVNDepth.EMPTY);
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"authentication fail", (Throwable)authexep);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error SVN import", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public RemoveFileResultDto removeFile(RemoveFileDto dto) {
        RemoveFileResultDto resultDto = new RemoveFileResultDto();
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        resultDto.setScmRoot(this.connection.getSvnRoot(dto.getUsername(), dto.getPassword()));
        if (resultDto.getScmRoot() == null) {
            resultDto.setScmRoot(this.connection.getSvnPath());
        }
        if (this.connection.getSvnPath().endsWith("/")) {
            resultDto.setFileRoot(this.connection.getSvnPath().substring(0, this.connection.getSvnPath().lastIndexOf(47)));
        } else {
            resultDto.setFileRoot(this.connection.getSvnPath());
        }
        this.connection.updateAuthentication(dto.getUsername(), dto.getPassword());
        try {
            this.connection.testConnection();
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Test connection fail", (Throwable)e);
            }
            resultDto.setError("connection failed");
            return resultDto;
        }
        if (dto.getScmPath() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        SVNCommitClient commitClient = new SVNCommitClient((ISVNRepositoryPool)this.connection.getManager(), (ISVNOptions)this.connection.getSvnOption());
        try {
            SVNURL[] scmPathTab = new SVNURL[]{SVNURL.parseURIEncoded((String)dto.getScmPath())};
            commitClient.doDelete(scmPathTab, "From scmwebeditor -- remove the file : " + dto.getScmPath());
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"authentication fail", (Throwable)authexep);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error SVN import", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public CreateDirectoryResultDto createDirectory(CreateDirectoryDto dto) {
        CreateDirectoryResultDto resultDto = new CreateDirectoryResultDto();
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        resultDto.setScmRoot(this.connection.getSvnRoot(dto.getUsername(), dto.getPassword()));
        if (resultDto.getScmRoot() == null) {
            resultDto.setScmRoot(this.connection.getSvnPath());
        }
        if (this.connection.getSvnPath().endsWith("/")) {
            resultDto.setFileRoot(this.connection.getSvnPath().substring(0, this.connection.getSvnPath().lastIndexOf(47)));
        } else {
            resultDto.setFileRoot(this.connection.getSvnPath());
        }
        this.connection.updateAuthentication(dto.getUsername(), dto.getPassword());
        try {
            this.connection.testConnection();
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Test connection fail", (Throwable)e);
            }
            resultDto.setError("connection failed");
            return resultDto;
        }
        if (dto.getDirectoryName() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getDirectoryName().equals("")) {
            resultDto.setError("redirect");
            return resultDto;
        }
        SVNCommitClient commitClient = new SVNCommitClient((ISVNRepositoryPool)this.connection.getManager(), (ISVNOptions)this.connection.getSvnOption());
        try {
            SVNURL[] urls = new SVNURL[]{SVNURL.parseURIEncoded((String)(dto.getParentDirectory() + "/" + dto.getDirectoryName()))};
            commitClient.doMkDir(urls, "From scmwebeditor -- create the directory : " + dto.getDirectoryName());
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"authentication fail", (Throwable)authexep);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error SVN import", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public RemoveDirectoryResultDto removeDirectory(RemoveDirectoryDto dto) {
        RemoveDirectoryResultDto resultDto = new RemoveDirectoryResultDto();
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        resultDto.setScmRoot(this.connection.getSvnRoot(dto.getUsername(), dto.getPassword()));
        if (resultDto.getScmRoot() == null) {
            resultDto.setScmRoot(this.connection.getSvnPath());
        }
        if (this.connection.getSvnPath().endsWith("/")) {
            resultDto.setFileRoot(this.connection.getSvnPath().substring(0, this.connection.getSvnPath().lastIndexOf(47)));
        } else {
            resultDto.setFileRoot(this.connection.getSvnPath());
        }
        this.connection.updateAuthentication(dto.getUsername(), dto.getPassword());
        try {
            this.connection.testConnection();
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Test connection fail", (Throwable)e);
            }
            resultDto.setError("connection failed");
            return resultDto;
        }
        if (dto.getDirectoryToRemove() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getDirectoryToRemove().equals("") || dto.getDirectoryToRemove().equals(resultDto.getFileRoot())) {
            resultDto.setError("redirect");
            return resultDto;
        }
        SVNCommitClient commitClient = new SVNCommitClient((ISVNRepositoryPool)this.connection.getManager(), (ISVNOptions)this.connection.getSvnOption());
        try {
            SVNURL[] urls = new SVNURL[]{SVNURL.parseURIEncoded((String)dto.getDirectoryToRemove())};
            commitClient.doDelete(urls, "From scmwebeditor -- remove the directory : " + dto.getDirectoryToRemove());
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"authentication fail", (Throwable)authexep);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error SVN import", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }

    public MoveFileResultDto moveFile(MoveFileDto dto) {
        SVNURL destUrl;
        SVNURL sourceUrl;
        MoveFileResultDto resultDto = new MoveFileResultDto();
        if (dto.getUsername() == null) {
            dto.setUsername("anonymous");
        }
        if (dto.getPassword() == null) {
            dto.setPassword("anonymous");
        }
        resultDto.setScmRoot(this.connection.getSvnRoot(dto.getUsername(), dto.getPassword()));
        if (resultDto.getScmRoot() == null) {
            resultDto.setScmRoot(this.connection.getSvnPath());
        }
        if (this.connection.getSvnPath().endsWith("/")) {
            resultDto.setFileRoot(this.connection.getSvnPath().substring(0, this.connection.getSvnPath().lastIndexOf(47)));
        } else {
            resultDto.setFileRoot(this.connection.getSvnPath());
        }
        this.connection.updateAuthentication(dto.getUsername(), dto.getPassword());
        try {
            this.connection.testConnection();
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Test connection fail", (Throwable)e);
            }
            resultDto.setError("connection failed");
            return resultDto;
        }
        if (dto.getFileToMove() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getFileToMove().equals("") || dto.getFileToMove().equals(resultDto.getFileRoot())) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getDestinationDirectory() == null) {
            resultDto.setError("redirect");
            return resultDto;
        }
        if (dto.getDestinationDirectory().equals("")) {
            resultDto.setError("redirect");
            return resultDto;
        }
        String fileName = dto.getFileToMove().substring(dto.getFileToMove().lastIndexOf(47) + 1);
        try {
            sourceUrl = SVNURL.parseURIEncoded((String)dto.getFileToMove());
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not get source file URL " + dto.getFileToMove()), (Throwable)e);
            }
            return resultDto;
        }
        try {
            destUrl = SVNURL.parseURIEncoded((String)(dto.getDestinationDirectory() + "/" + fileName));
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not get destination file URL " + dto.getDestinationDirectory() + "/" + fileName), (Throwable)e);
            }
            return resultDto;
        }
        SVNCopySource[] sourceFileTab = new SVNCopySource[]{new SVNCopySource(SVNRevision.HEAD, SVNRevision.HEAD, sourceUrl)};
        SVNCopyClient copyClient = new SVNCopyClient((ISVNRepositoryPool)this.connection.getManager(), (ISVNOptions)this.connection.getSvnOption());
        try {
            copyClient.doCopy(sourceFileTab, destUrl, true, false, true, "From scmwebeditor -- move the file : " + sourceUrl.getPath() + " to : " + destUrl.getPath(), null);
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"authentication fail", (Throwable)authexep);
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error SVN import", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        return resultDto;
    }
}

