/* *##% Nuiton utilities library
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

/* *
 * LutinLogEvent.java
 *
 * Created: 9 sept. 06 04:01:26
 *
 * @author poussin
 * @version $Revision: 1637 $
 *
 * Last update: $Date: 2009-06-21 04:53:31 +0200 (dim., 21 juin 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.log;

import java.util.EventObject;


/** @author poussin */

public class LutinLogEvent extends EventObject {

    /**  */
    private static final long serialVersionUID = 1L;

    private LogType logType;
    private String msg;
    private Throwable eee;
    private long time;

    static public enum LogType {
        user, trace, debug, info, warn, error, fatal
    }

    /**
     * @param source  
     * @param logType 
     * @param msg 
     * @param eee
     */
    public LutinLogEvent(Object source, LogType logType, String msg, Throwable eee) {
        super(source);
        this.logType = logType;
        this.msg = msg;
        this.eee = eee;
        this.time = System.currentTimeMillis();
    }

    /* (non-Javadoc)
     * @see java.util.EventObject#getSource()
     */
    public LutinLog getLutinLog() {
        return (LutinLog) super.getSource();
    }

    /** @return the logType */
    public LogType getLogType() {
        return this.logType;
    }

    /** @return the msg */
    public String getMsg() {
        return this.msg;
    }

    /** @return the eee */
    public Throwable getThrowable() {
        return this.eee;
    }

    /** @return the time */
    public long getTime() {
        return this.time;
    }
}


