/* *##% Nuiton utilities library
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

/* *
 * LutinLogFactory.java
 *
 * Created: 9 sept. 06 03:45:29
 *
 * @author poussin
 * @version $Revision: 1637 $
 *
 * Last update: $Date: 2009-06-21 04:53:31 +0200 (dim., 21 juin 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.nuiton.util.CategorisedListenerSet;

import java.util.Timer;


/** @author poussin */

public class LutinLogFactory extends LogFactory {

    static private LutinLogFactory instance = null;

    protected LogFactory parentFactory = null;
    protected CategorisedListenerSet<LutinLogListener> listeners = new CategorisedListenerSet<LutinLogListener>();
    protected long DefaultActiveProgressMonitorTime = 0;
    protected long DefaultTimeout = 0;

    private Timer timer;

    static public LutinLogFactory getInstance() {
        if (instance == null) {
            LogFactory factory = LogFactory.getFactory();
            if (factory instanceof LutinLogFactory) {
                instance = (LutinLogFactory) factory;
            } else {
                instance = new LutinLogFactory();
            }
        }
        return instance;
    }

    static public LutinLog getLutinLog(Class<?> clazz) {
        LutinLogFactory factory = LutinLogFactory.getInstance();
        LutinLog result = (LutinLog) factory.getInstance(clazz);
        return result;
    }

    static public LutinLog getLutinLog(String cat) {
        LutinLogFactory factory = LutinLogFactory.getInstance();
        LutinLog result = (LutinLog) factory.getInstance(cat);
        return result;
    }

    /** @return the defaultActiveProgressMonitorTime */
    public long getDefaultActiveProgressMonitorTime() {
        return this.DefaultActiveProgressMonitorTime;
    }

    /**
     * @param defaultActiveProgressMonitorTime
     *         the defaultActiveProgressMonitorTime to set
     */
    public void setDefaultActiveProgressMonitorTime(
            long defaultActiveProgressMonitorTime) {
        this.DefaultActiveProgressMonitorTime = defaultActiveProgressMonitorTime;
    }

    /** @return the defaultTimeout */
    public long getDefaultTimeout() {
        return this.DefaultTimeout;
    }

    /** @param defaultTimeout the defaultTimeout to set */
    public void setDefaultTimeout(long defaultTimeout) {
        this.DefaultTimeout = defaultTimeout;
    }

    ///////////////////////////////////////////////////////////////////////////
    //
    // L I S T E N E R
    //
    ///////////////////////////////////////////////////////////////////////////

    /**
     * Add listener on all LutinLog
     *
     * @param l
     */
    public void addLutinLogListener(LutinLogListener l) {
        listeners.add(this, l);
    }

    /**
     * Add listener on specific LutinLog
     *
     * @param log
     * @param l
     */
    public void addLutinLogListener(LutinLog log, LutinLogListener l) {
        listeners.addCategory(this, log);
        listeners.add(log, l);
    }

    /**
     * Add listener on all LutinLog
     *
     * @param l
     */
    public void removeLutinLogListener(LutinLogListener l) {
        listeners.remove(this, l);
    }

    /**
     * Add listener on specific LutinLog
     *
     * @param log
     * @param l
     */
    public void removeLutinLogListener(LutinLog log, LutinLogListener l) {
        listeners.remove(log, l);
    }

    /**
     * Return le réel commons-logging a utiliser
     *
     * @return the parentFactory
     */
    protected LogFactory getParentFactory() {
        if (this.parentFactory == null) {
            this.parentFactory = new LogFactoryImpl();
        }
        return this.parentFactory;
    }

    ///////////////////////////////////////////////////////////////////////////
    //
    // C O M M O N S - L O G G I N G   M E T H O D
    //
    ///////////////////////////////////////////////////////////////////////////

    /* (non-Javadoc)
    * @see org.apache.commons.logging.LogFactory#getAttribute(java.lang.String)
    */

    @Override
    public Object getAttribute(String arg0) {
        Object result = getParentFactory().getAttribute(arg0);
        return result;
    }

    /* (non-Javadoc)
     * @see org.apache.commons.logging.LogFactory#getAttributeNames()
     */
    @Override
    public String[] getAttributeNames() {
        String[] result = getParentFactory().getAttributeNames();
        return result;
    }

    /* (non-Javadoc)
     * @see org.apache.commons.logging.LogFactory#getInstance(java.lang.Class)
     */
    @Override
    public Log getInstance(Class arg0) throws LogConfigurationException {
        Log log = getParentFactory().getInstance(arg0);
        Log result = new LutinLog(this, log);
        listeners.addCategory(this, result);
        return result;
    }

    /* (non-Javadoc)
     * @see org.apache.commons.logging.LogFactory#getInstance(java.lang.String)
     */
    @Override
    public Log getInstance(String arg0) throws LogConfigurationException {
        Log log = getParentFactory().getInstance(arg0);
        Log result = new LutinLog(this, log);
        listeners.addCategory(this, result);
        return result;
    }

    /* (non-Javadoc)
     * @see org.apache.commons.logging.LogFactory#release()
     */
    @Override
    public void release() {
        getParentFactory().release();
    }

    /* (non-Javadoc)
     * @see org.apache.commons.logging.LogFactory#removeAttribute(java.lang.String)
     */
    @Override
    public void removeAttribute(String arg0) {
        getParentFactory().removeAttribute(arg0);
    }

    /* (non-Javadoc)
     * @see org.apache.commons.logging.LogFactory#setAttribute(java.lang.String, java.lang.Object)
     */
    @Override
    public void setAttribute(String arg0, Object arg1) {
        getParentFactory().setAttribute(arg0, arg1);
    }

    /** @return  the logger timer */
    public Timer getTimer() {
        if (timer == null) {
            timer = new Timer("LutinLogTimer", true);
        }
        return timer;
    }

}


