package org.nuiton.util.updater;

/*
 * #%L
 * Nuiton Utils :: Nuiton Updater
 * $Id: ApplicationInfo.java 2528 2013-03-12 23:03:34Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.6.11/nuiton-updater/src/main/java/org/nuiton/util/updater/ApplicationInfo.java $
 * %%
 * Copyright (C) 2013 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.io.File;
import java.io.Serializable;

/**
 * TODO
 *
 * @author bpoussin <poussing@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @since 2.7
 */
public class ApplicationInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    public String name;

    public String oldVersion;

    public String newVersion;

    public String url;

    public boolean needAuthentication;

    public String login;

    public char[] password;

    public File destDir;

    public ApplicationInfo(String name,
                           String oldVersion,
                           String newVersion,
                           String url,
                           File destDir,
                           boolean needAuthentication) {
        this.name = name;
        this.oldVersion = oldVersion;
        this.newVersion = newVersion;
        this.url = url;
        this.needAuthentication = needAuthentication;
        this.destDir = destDir;
    }

    public void setAuthentication(String login, char[] password) {
        this.login = login;
        this.password = password;
    }

    @Override
    public String toString() {
        String result = String.format(
                "App: %s, oldVersion: %s, newVersion: %s, url: %s, destDir:%s",
                name, oldVersion, newVersion, url, destDir);
        return result;
    }

}
