/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Method;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.nuiton.profiling.Trace;
import org.nuiton.profiling.WebService;

@Aspect
public abstract class NuitonTrace {
    public static Trace trace;
    public static final String DISTINCT_THREAD_CALL_OPTION = "nuitonprofiling_distinctThreadCall";
    public static final String PORT_OPTION = "nuitonprofiling_webport";
    public static final String AUTO_SAVE_FILENAME_OPTION = "nuitonprofiling_autosavefile";
    protected static boolean initilized;

    @Pointcut
    abstract void executeMethod();

    @Before(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceBeforeExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        trace.enter(method);
    }

    @AfterThrowing(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceAfterThrowingExecute(JoinPoint jp) {
        this.traceAfterExecute(jp);
    }

    @After(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        trace.exit(method);
    }

    public static String getStatisticsCSVAndClear() {
        String result = trace.getStatisticsCSV();
        trace.clearStatistics();
        return result;
    }

    public static String getStatisticsJson() {
        String result = trace.getStatisticsJson();
        return result;
    }

    public static void clearStatistics() {
        trace.clearStatistics();
    }

    public static String getStatisticsAndClear() {
        String result = trace.getStatisticsText();
        trace.clearStatistics();
        return result;
    }

    public static void printStatisticsAndClear() {
        NuitonTrace.printStatisticsAndClear(System.out);
    }

    public static void printStatisticsAndClear(PrintStream printer) {
        String stat = NuitonTrace.getStatisticsAndClear();
        if (stat != null && !"".equals(stat)) {
            printer.println(stat);
        }
    }

    protected static String getOption(String optionName) {
        String result = System.getProperty(optionName);
        if (result == null) {
            result = System.getenv(optionName);
        }
        return result;
    }

    protected static void init() {
        if (initilized) {
            return;
        }
        initilized = true;
        System.out.println("Init Nuiton Profiling ...");
        String distinctThreadCall = NuitonTrace.getOption(DISTINCT_THREAD_CALL_OPTION);
        trace = new Trace(true, Boolean.parseBoolean(distinctThreadCall));
        String portString = NuitonTrace.getOption(PORT_OPTION);
        System.out.println("NuitonProfiling web port: " + portString);
        if (portString != null) {
            try {
                int port = Integer.parseInt(portString);
                if (port > 0) {
                    new WebService(port).start();
                }
            }
            catch (Exception eee) {
                eee.printStackTrace(System.err);
                System.err.println("Can't parse port number: " + portString);
            }
        }
        final String file = NuitonTrace.getOption(AUTO_SAVE_FILENAME_OPTION);
        System.out.println("NuitonProfiling auto save file: " + file);
        if (file != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    FileWriter out = null;
                    try {
                        String stat = NuitonTrace.getStatisticsCSVAndClear();
                        out = new FileWriter(file);
                        out.write(stat);
                    }
                    catch (IOException eee) {
                        try {
                            eee.printStackTrace(System.err);
                            System.err.println("Can't write Statistic file: " + file);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Writer)out);
                    }
                    IOUtils.closeQuietly((Writer)out);
                }
            });
        }
    }

    public static void main(String ... args) {
        System.out.println("Starting Nuiton Profiling ...");
        String portString = args != null && args.length > 0 ? args[0] : NuitonTrace.getOption(PORT_OPTION);
        if (portString == null) {
            portString = "4488";
        }
        System.out.println("NuitonProfiling web port: " + portString);
        try {
            int port = Integer.parseInt(portString);
            if (port > 0) {
                new WebService(port).start();
            }
        }
        catch (Exception eee) {
            eee.printStackTrace(System.err);
            System.err.println("Can't parse port number: " + portString);
        }
    }

    static {
        initilized = false;
        NuitonTrace.init();
    }
}

