/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public abstract class NuitonTrace {
    private static final List<NuitonTrace> instances = new ArrayList<NuitonTrace>();
    protected Map<Method, Statistic> statistics = new LinkedHashMap<Method, Statistic>();
    protected Map<Method, Caller<Method>> callers = new HashMap<Method, Caller<Method>>();
    protected static final ThreadLocal<Stack<Call>> callStack = new ThreadLocal<Stack<Call>>(){

        @Override
        protected Stack<Call> initialValue() {
            Stack<Call> result = new Stack<Call>();
            return result;
        }
    };

    public NuitonTrace() {
        instances.add(this);
    }

    public Statistic getStatistics(Method method) {
        Statistic result = this.statistics.get(method);
        if (result == null) {
            result = new Statistic(method);
            this.statistics.put(method, result);
        }
        return result;
    }

    public Caller<Method> getCallers(Method method) {
        Caller<Method> result = this.callers.get(method);
        if (result == null) {
            result = new Caller();
            this.callers.put(method, result);
        }
        return result;
    }

    @Pointcut
    abstract void executeMethod();

    @Before(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceBeforeExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        long current = System.nanoTime();
        Call stackItem = new Call(method, 0L, current, current);
        callStack.get().push(stackItem);
    }

    @AfterThrowing(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceAfterThrowingExecute(JoinPoint jp) {
        this.traceAfterExecute(jp);
    }

    @After(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        long current = System.nanoTime();
        Stack<Call> callStack = NuitonTrace.callStack.get();
        if (!callStack.isEmpty()) {
            Call stackItem = callStack.pop();
            long timeSpent = current - stackItem.timeStart;
            long timeSpentNestMethod = current - stackItem.timeStartNestMethod;
            Statistic stat = this.getStatistics(method);
            ++stat.call;
            stat.callNestMethod += stackItem.callNestMethod;
            stat.timeTotal += timeSpent;
            stat.timeTotalNestMethod += timeSpentNestMethod;
            if (stat.timeMin > timeSpent) {
                stat.timeMin = timeSpent;
            }
            if (stat.timeMax < timeSpent) {
                stat.timeMax = timeSpent;
            }
            if (!callStack.isEmpty()) {
                Call parent = callStack.peek();
                ++parent.callNestMethod;
                parent.timeStart += timeSpentNestMethod;
                this.getCallers(method).add(parent.method);
            }
        }
    }

    public static String getStatisticsCSVAndClear() {
        StringBuilder result = new StringBuilder();
        result.append("method;").append("call;").append("min;").append("mean;").append("max;").append("total;").append("call_nest;").append("total_with_nest;").append("callers;").append("\n");
        for (NuitonTrace trace : instances) {
            for (Method method : trace.statistics.keySet()) {
                Statistic stat = trace.getStatistics(method);
                Caller<Method> caller = trace.getCallers(method);
                long meanTime = stat.timeTotal / stat.call;
                result.append(method).append(";").append(stat.call).append(";").append(DurationFormatUtils.formatDuration((long)(stat.timeMin / 1000000L), (String)"s'.'S")).append(";").append(DurationFormatUtils.formatDuration((long)(meanTime / 1000000L), (String)"s'.'S")).append(";").append(DurationFormatUtils.formatDuration((long)(stat.timeMax / 1000000L), (String)"s'.'S")).append(";").append(DurationFormatUtils.formatDuration((long)(stat.timeTotal / 1000000L), (String)"s'.'S")).append(";").append(stat.callNestMethod).append(";").append(DurationFormatUtils.formatDuration((long)(stat.timeTotalNestMethod / 1000000L), (String)"s'.'S")).append(";").append(caller).append("\n");
            }
            trace.statistics.clear();
            trace.callers.clear();
        }
        return result.toString();
    }

    public static String getStatisticsAndClear() {
        StringBuilder result = new StringBuilder();
        for (NuitonTrace trace : instances) {
            result.append("--- Statistics ---\n");
            for (Method method : trace.statistics.keySet()) {
                Statistic stat = trace.getStatistics(method);
                long meanTime = stat.timeTotal / stat.call;
                result.append(method).append("\t").append(" call: ").append(stat.call).append(" min: ").append(DurationFormatUtils.formatDuration((long)(stat.timeMin / 1000000L), (String)"s'.'S")).append(" mean: ").append(DurationFormatUtils.formatDuration((long)(meanTime / 1000000L), (String)"s'.'S")).append(" max: ").append(DurationFormatUtils.formatDuration((long)(stat.timeMax / 1000000L), (String)"s'.'S")).append(" total: ").append(DurationFormatUtils.formatDuration((long)(stat.timeTotal / 1000000L), (String)"s'.'S")).append(" call_nest: ").append(stat.callNestMethod).append(" total_with_nest: ").append(DurationFormatUtils.formatDuration((long)(stat.timeTotalNestMethod / 1000000L), (String)"s'.'S")).append(" callers: ").append(trace.getCallers(method)).append("\n");
            }
            result.append("--------------------\n");
            trace.statistics.clear();
            trace.callers.clear();
        }
        return result.toString();
    }

    public static void printStatisticsAndClear() {
        NuitonTrace.printStatisticsAndClear(System.out);
    }

    public static void printStatisticsAndClear(PrintStream printer) {
        String stat = NuitonTrace.getStatisticsAndClear();
        if (stat != null && !"".equals(stat)) {
            printer.println(stat);
        }
    }

    protected static class Caller<E> {
        protected Map<E, Integer> data = new HashMap<E, Integer>();

        protected Caller() {
        }

        public void add(E e) {
            Integer v = this.data.get(e);
            if (v == null) {
                v = 0;
            }
            this.data.put(e, v + 1);
        }

        public String toString() {
            Comparator comparator = new Comparator<Map.Entry<E, Integer>>(){

                @Override
                public int compare(Map.Entry<E, Integer> o1, Map.Entry<E, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            };
            Set<Map.Entry<E, Integer>> entries = this.data.entrySet();
            TreeSet<Map.Entry<E, Integer>> sorted = new TreeSet<Map.Entry<E, Integer>>(comparator);
            sorted.addAll(entries);
            StringBuilder result = new StringBuilder();
            for (Map.Entry entry : sorted) {
                result.append(entry.getValue()).append("=[").append(entry.getKey()).append("]").append(",");
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            return result.toString();
        }
    }

    protected static class Call {
        Method method;
        long callNestMethod;
        long timeStart;
        long timeStartNestMethod;

        public Call(Method method, long callNestMethod, long timeStart, long timeStartNestMethod) {
            this.method = method;
            this.callNestMethod = callNestMethod;
            this.timeStart = timeStart;
            this.timeStartNestMethod = timeStartNestMethod;
        }
    }

    protected static class Statistic {
        Method method;
        long call;
        long callNestMethod;
        long timeMin;
        long timeMax;
        long timeTotal;
        long timeTotalNestMethod;

        public Statistic(Method method) {
            this.method = method;
        }
    }
}

