/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;

public class ApplicationConfigReportRenderer
extends AbstractMavenReportRenderer {
    protected final I18N i18n;
    protected final Locale locale;
    protected final String bundleName;
    protected final Set<ApplicationConfigProvider> configProviders;
    protected final boolean optionWithDetail;

    public ApplicationConfigReportRenderer(Sink sink, I18N i18n, Locale locale, String bundleName, Set<ApplicationConfigProvider> configProviders, boolean optionWithDetail) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.bundleName = bundleName;
        this.sink = sink;
        this.configProviders = configProviders;
        this.optionWithDetail = optionWithDetail;
    }

    public String getTitle() {
        return this.getText("report.title");
    }

    public void renderBody() {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.lineBreak();
        this.sink.paragraph();
        this.sink.text(this.getText("report.overview.text"));
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.link("http://maven-site.nuiton.org/nuiton-utils/nuiton-config/index.html");
        this.sink.text(this.getText("report.overview.more.information"));
        this.sink.link_();
        this.sink.paragraph_();
        this.sink.lineBreak();
        this.renderProviderSummaryTable();
        this.sink.section1_();
        if (CollectionUtils.isNotEmpty(this.configProviders)) {
            this.sink.section1();
            this.sink.sectionTitle1();
            this.sink.text(this.getText("report.detail.title"));
            this.sink.sectionTitle1_();
            this.sink.lineBreak();
            this.sink.paragraph();
            this.sink.text(this.getText("report.detail.text"));
            this.sink.paragraph_();
            for (ApplicationConfigProvider configProvider : this.configProviders) {
                this.renderConfigProviderDetail(configProvider);
            }
            this.sink.section1_();
        }
    }

    protected void renderProviderSummaryTable() {
        if (CollectionUtils.isEmpty(this.configProviders)) {
            this.sink.text(this.getText("report.detail.text.noConfig"));
        } else {
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.config.name"));
            this.sinkHeaderCellText(this.getText("report.config.description"));
            this.sinkHeaderCellText(this.getText("report.config.nbOptions"));
            this.sinkHeaderCellText(this.getText("report.config.nbActions"));
            this.sink.tableRow_();
            for (ApplicationConfigProvider configProvider : this.configProviders) {
                this.sink.tableRow();
                this.sinkCellLink(configProvider.getName(), "./application-config-report.html#detail_" + configProvider.getName());
                this.sinkCellText(configProvider.getDescription(this.locale));
                this.sinkCellText(configProvider.getOptions().length + "");
                this.sinkCellText(configProvider.getActions().length + "");
                this.sink.tableRow_();
            }
            this.sink.table_();
        }
    }

    protected void renderConfigProviderDetail(ApplicationConfigProvider configProvider) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.anchor("detail_" + configProvider.getName());
        this.sink.text(this.getText("report.detail.configuration.title") + "   " + configProvider.getName());
        this.sink.anchor_();
        this.sink.sectionTitle2_();
        this.sink.lineBreak();
        this.sink.paragraph();
        this.sink.text(this.getText("report.config.name") + " : ");
        this.sink.bold();
        this.sink.text(configProvider.getName());
        this.sink.bold_();
        this.sink.paragraph_();
        this.sink.lineBreak();
        this.sink.paragraph();
        this.sink.text(this.getText("report.config.description") + " : ");
        this.sink.bold();
        this.sink.text(configProvider.getDescription(this.locale));
        this.sink.bold_();
        this.sink.paragraph_();
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.anchor("detail_options_" + configProvider.getName());
        this.sink.text(this.getText("report.detail.options.title"));
        this.sink.anchor_();
        this.sink.sectionTitle3_();
        this.sink.lineBreak();
        Collection<ConfigOptionDef> options = this.getOptions(configProvider);
        this.renderOptionDefsTable(configProvider, options);
        if (this.optionWithDetail) {
            for (ConfigOptionDef option : options) {
                this.renderProviderOptionDetail(configProvider, option);
            }
        }
        this.sink.section3_();
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.text(this.getText("report.detail.actions.title"));
        this.sink.sectionTitle3_();
        this.sink.lineBreak();
        this.renderActionDefsTable(configProvider.getActions());
        this.sink.section3_();
        this.sink.section2_();
    }

    protected void renderOptionDefsTable(ApplicationConfigProvider configProvider, Collection<ConfigOptionDef> options) {
        if (options.isEmpty()) {
            this.sink.paragraph();
            this.sink.bold();
            this.sink.text(this.getText("report.detail.options.noOptions"));
            this.sink.bold_();
            this.sink.paragraph_();
        } else {
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.config.option.key"));
            this.sinkHeaderCellText(this.getText("report.config.option.description"));
            if (!this.optionWithDetail) {
                this.sinkHeaderCellText(this.getText("report.config.option.type"));
            }
            this.sinkHeaderCellText(this.getText("report.config.option.defaultValue"));
            if (!this.optionWithDetail) {
                this.sinkHeaderCellText(this.getText("report.config.option.final"));
                this.sinkHeaderCellText(this.getText("report.config.option.transient"));
            }
            this.sink.tableRow_();
            for (ConfigOptionDef option : options) {
                this.sink.tableRow();
                if (this.optionWithDetail) {
                    this.sinkCellLink(option.getKey(), "./application-config-report.html#detail_" + configProvider.getName() + "_" + option.getKey());
                } else {
                    this.sinkCellText(option.getKey());
                }
                this.sinkCellText(I18n.l((Locale)this.locale, (String)option.getDescription(), (Object[])new Object[0]));
                if (!this.optionWithDetail) {
                    this.sinkCellText(option.getType().getName());
                }
                this.sinkCellVerbatimText(this.getDefaultValue(option));
                if (!this.optionWithDetail) {
                    this.sinkCellText(this.getText(!option.isFinal()));
                    this.sinkCellText(this.getText(!option.isTransient()));
                }
                this.sink.tableRow_();
            }
            this.sink.table_();
        }
    }

    protected void renderActionDefsTable(ConfigActionDef ... actions) {
        if (actions.length == 0) {
            this.sink.paragraph();
            this.sink.bold();
            this.sink.text(this.getText("report.detail.actions.noActions"));
            this.sink.bold_();
            this.sink.paragraph_();
        } else {
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.config.action.action"));
            this.sinkHeaderCellText(this.getText("report.config.action.aliases"));
            this.sink.tableRow_();
            for (ConfigActionDef action : actions) {
                this.sink.tableRow();
                this.sinkCellText(action.getAction());
                this.sinkCellText(I18n.l((Locale)this.locale, (String)Arrays.toString(action.getAliases()), (Object[])new Object[0]));
                this.sink.tableRow_();
            }
            this.sink.table_();
        }
    }

    protected void renderProviderOptionDetail(ApplicationConfigProvider configProvider, ConfigOptionDef option) {
        SinkEventAttributeSet cellWidth = new SinkEventAttributeSet();
        cellWidth.addAttribute((Object)"width", (Object)"80%");
        SinkEventAttributeSet headerWidth = new SinkEventAttributeSet();
        headerWidth.addAttribute((Object)"width", (Object)"20%");
        this.sink.section4();
        this.sink.sectionTitle4();
        this.sink.anchor("detail_" + configProvider.getName() + "_" + option.getKey());
        this.sink.text(this.getText("report.config.option.detail") + "  '" + option.getKey() + "'");
        this.sink.sectionTitle4_();
        this.sink.lineBreak();
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sinkHeaderCellText((SinkEventAttributes)headerWidth, this.getText("report.config.option.key"));
        this.sink.tableCell((SinkEventAttributes)cellWidth);
        this.sink.nonBreakingSpace();
        this.sink.bold();
        this.sink.text(option.getKey());
        this.sink.bold_();
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText((SinkEventAttributes)headerWidth, this.getText("report.config.option.description"));
        this.sink.tableCell((SinkEventAttributes)cellWidth);
        this.sink.nonBreakingSpace();
        this.sink.text(I18n.l((Locale)this.locale, (String)option.getDescription(), (Object[])new Object[0]));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText((SinkEventAttributes)headerWidth, this.getText("report.config.option.defaultValue"));
        this.sink.tableCell((SinkEventAttributes)cellWidth);
        this.sink.nonBreakingSpace();
        this.sink.bold();
        this.sink.text(this.getDefaultValue(option));
        this.sink.bold_();
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText((SinkEventAttributes)headerWidth, this.getText("report.config.option.type"));
        this.sink.tableCell((SinkEventAttributes)cellWidth);
        this.sink.nonBreakingSpace();
        this.sink.text(option.getType().getName());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText((SinkEventAttributes)headerWidth, this.getText("report.config.option.final"));
        this.sink.tableCell((SinkEventAttributes)cellWidth);
        this.sink.nonBreakingSpace();
        this.sink.text(this.getText(!option.isFinal()));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText((SinkEventAttributes)headerWidth, this.getText("report.config.option.transient"));
        this.sink.tableCell((SinkEventAttributes)cellWidth);
        this.sink.nonBreakingSpace();
        this.sink.text(this.getText(!option.isTransient()));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
        this.sink.paragraph();
        this.sink.link("./application-config-report.html#detail_options_" + configProvider.getName());
        this.sink.text(this.getText("report.back.options.table"));
        this.sink.link_();
        this.sink.paragraph_();
        this.sink.section4_();
    }

    protected String getText(boolean key) {
        return this.getText("report." + String.valueOf(key));
    }

    protected String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    protected String getDefaultValue(ConfigOptionDef option) {
        String defaultValue = option.getDefaultValue();
        if (StringUtils.isBlank((String)defaultValue)) {
            defaultValue = this.getText("report.noDefaultValue");
        }
        return defaultValue;
    }

    protected void renderWarningIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_warning_sml.gif");
        this.sink.figure_();
    }

    protected void renderErrorIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_error_sml.gif");
        this.sink.figure_();
    }

    protected void renderSuccessIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_success_sml.gif");
        this.sink.figure_();
    }

    protected void renderInfoIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_info_sml.gif");
        this.sink.figure_();
    }

    protected void sinkHeaderCellText(String text) {
        this.sink.tableHeaderCell();
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkHeaderCellText(SinkEventAttributes width, String text) {
        this.sink.tableHeaderCell(width);
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkCellText(SinkEventAttributes width, String text) {
        this.sink.tableCell(width);
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void sinkCellText(String text) {
        this.sink.tableCell();
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void sinkCellVerbatimText(String text) {
        this.sink.tableCell();
        this.sink.verbatim(SinkEventAttributeSet.MONOSPACED);
        this.sink.text(text);
        this.sink.verbatim_();
        this.sink.tableCell_();
    }

    protected void sinkCellLink(String text, String url) {
        this.sink.tableCell();
        this.sink.link(url);
        this.sink.text(text);
        this.sink.link_();
        this.sink.tableCell_();
    }

    protected Collection<ConfigOptionDef> getOptions(ApplicationConfigProvider configProvider) {
        ArrayList<ConfigOptionDef> result = new ArrayList<ConfigOptionDef>(Arrays.asList(configProvider.getOptions()));
        Collections.sort(result, new Comparator<ConfigOptionDef>(){

            @Override
            public int compare(ConfigOptionDef o1, ConfigOptionDef o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return result;
    }
}

