package org.nuiton.db.meta;

/*-
 * #%L
 * Nuiton DB Meta
 * %%
 * Copyright (C) 2019 - 2021 Nuiton
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TableMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTableMeta.builder()}.
 */
@Generated(from = "TableMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTableMeta implements TableMeta {
  private final String name;
  private final boolean isView;
  private final ImmutableList<ColumnMeta> columns;
  private final @Nullable Long count;
  private final @Nullable String comment;

  private ImmutableTableMeta(
      String name,
      boolean isView,
      ImmutableList<ColumnMeta> columns,
      @Nullable Long count,
      @Nullable String comment) {
    this.name = name;
    this.isView = isView;
    this.columns = columns;
    this.count = count;
    this.comment = comment;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code isView} attribute
   */
  @Override
  public boolean isView() {
    return isView;
  }

  /**
   * @return The value of the {@code columns} attribute
   */
  @Override
  public ImmutableList<ColumnMeta> getColumns() {
    return columns;
  }

  /**
   * @return The value of the {@code count} attribute
   */
  @Override
  public Optional<Long> getCount() {
    return Optional.ofNullable(count);
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @Override
  public Optional<String> getComment() {
    return Optional.ofNullable(comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableMeta#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableMeta withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTableMeta(newValue, this.isView, this.columns, this.count, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableMeta#isView() isView} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isView
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableMeta withIsView(boolean value) {
    if (this.isView == value) return this;
    return new ImmutableTableMeta(this.name, value, this.columns, this.count, this.comment);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TableMeta#getColumns() columns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTableMeta withColumns(ColumnMeta... elements) {
    ImmutableList<ColumnMeta> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTableMeta(this.name, this.isView, newValue, this.count, this.comment);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TableMeta#getColumns() columns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of columns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTableMeta withColumns(Iterable<? extends ColumnMeta> elements) {
    if (this.columns == elements) return this;
    ImmutableList<ColumnMeta> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTableMeta(this.name, this.isView, newValue, this.count, this.comment);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TableMeta#getCount() count} attribute.
   * @param value The value for count
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTableMeta withCount(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.count, newValue)) return this;
    return new ImmutableTableMeta(this.name, this.isView, this.columns, newValue, this.comment);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TableMeta#getCount() count} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for count
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTableMeta withCount(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.count, value)) return this;
    return new ImmutableTableMeta(this.name, this.isView, this.columns, value, this.comment);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TableMeta#getComment() comment} attribute.
   * @param value The value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTableMeta withComment(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "comment");
    if (Objects.equals(this.comment, newValue)) return this;
    return new ImmutableTableMeta(this.name, this.isView, this.columns, this.count, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TableMeta#getComment() comment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTableMeta withComment(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableTableMeta(this.name, this.isView, this.columns, this.count, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTableMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTableMeta
        && equalTo((ImmutableTableMeta) another);
  }

  private boolean equalTo(ImmutableTableMeta another) {
    return name.equals(another.name)
        && isView == another.isView
        && columns.equals(another.columns)
        && Objects.equals(count, another.count)
        && Objects.equals(comment, another.comment);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code isView}, {@code columns}, {@code count}, {@code comment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Booleans.hashCode(isView);
    h += (h << 5) + columns.hashCode();
    h += (h << 5) + Objects.hashCode(count);
    h += (h << 5) + Objects.hashCode(comment);
    return h;
  }

  /**
   * Prints the immutable value {@code TableMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TableMeta")
        .omitNullValues()
        .add("name", name)
        .add("isView", isView)
        .add("columns", columns)
        .add("count", count)
        .add("comment", comment)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TableMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TableMeta instance
   */
  public static ImmutableTableMeta copyOf(TableMeta instance) {
    if (instance instanceof ImmutableTableMeta) {
      return (ImmutableTableMeta) instance;
    }
    return ImmutableTableMeta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTableMeta ImmutableTableMeta}.
   * <pre>
   * ImmutableTableMeta.builder()
   *    .name(String) // required {@link TableMeta#getName() name}
   *    .isView(boolean) // required {@link TableMeta#isView() isView}
   *    .addColumns|addAllColumns(org.nuiton.db.meta.ColumnMeta) // {@link TableMeta#getColumns() columns} elements
   *    .count(Long) // optional {@link TableMeta#getCount() count}
   *    .comment(String) // optional {@link TableMeta#getComment() comment}
   *    .build();
   * </pre>
   * @return A new ImmutableTableMeta builder
   */
  public static ImmutableTableMeta.Builder builder() {
    return new ImmutableTableMeta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTableMeta ImmutableTableMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TableMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_IS_VIEW = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private boolean isView;
    private ImmutableList.Builder<ColumnMeta> columns = ImmutableList.builder();
    private @Nullable Long count;
    private @Nullable String comment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TableMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TableMeta instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      isView(instance.isView());
      addAllColumns(instance.getColumns());
      Optional<Long> countOptional = instance.getCount();
      if (countOptional.isPresent()) {
        count(countOptional);
      }
      Optional<String> commentOptional = instance.getComment();
      if (commentOptional.isPresent()) {
        comment(commentOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TableMeta#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TableMeta#isView() isView} attribute.
     * @param isView The value for isView 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isView(boolean isView) {
      this.isView = isView;
      initBits &= ~INIT_BIT_IS_VIEW;
      return this;
    }

    /**
     * Adds one element to {@link TableMeta#getColumns() columns} list.
     * @param element A columns element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumns(ColumnMeta element) {
      this.columns.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TableMeta#getColumns() columns} list.
     * @param elements An array of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumns(ColumnMeta... elements) {
      this.columns.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TableMeta#getColumns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder columns(Iterable<? extends ColumnMeta> elements) {
      this.columns = ImmutableList.builder();
      return addAllColumns(elements);
    }

    /**
     * Adds elements to {@link TableMeta#getColumns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllColumns(Iterable<? extends ColumnMeta> elements) {
      this.columns.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link TableMeta#getCount() count} to count.
     * @param count The value for count
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder count(long count) {
      this.count = count;
      return this;
    }

    /**
     * Initializes the optional value {@link TableMeta#getCount() count} to count.
     * @param count The value for count
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder count(Optional<Long> count) {
      this.count = count.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TableMeta#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      return this;
    }

    /**
     * Initializes the optional value {@link TableMeta#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(Optional<String> comment) {
      this.comment = comment.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTableMeta ImmutableTableMeta}.
     * @return An immutable instance of TableMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTableMeta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTableMeta(name, isView, columns.build(), count, comment);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_IS_VIEW) != 0) attributes.add("isView");
      return "Cannot build TableMeta, some of required attributes are not set " + attributes;
    }
  }
}
