package org.nuiton.db.meta;

/*-
 * #%L
 * Nuiton DB Meta
 * %%
 * Copyright (C) 2019 - 2021 Nuiton
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CustomTypeMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCustomTypeMeta.builder()}.
 */
@Generated(from = "CustomTypeMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCustomTypeMeta implements CustomTypeMeta {
  private final String name;
  private final @Nullable String comment;
  private final @Nullable Class<? extends Enum> enumEquivalence;
  private final ImmutableList<String> values;

  private ImmutableCustomTypeMeta(
      String name,
      @Nullable String comment,
      @Nullable Class<? extends Enum> enumEquivalence,
      ImmutableList<String> values) {
    this.name = name;
    this.comment = comment;
    this.enumEquivalence = enumEquivalence;
    this.values = values;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @Override
  public Optional<String> getComment() {
    return Optional.ofNullable(comment);
  }

  /**
   * @return The value of the {@code enumEquivalence} attribute
   */
  @Override
  public Optional<Class<? extends Enum>> getEnumEquivalence() {
    return Optional.ofNullable(enumEquivalence);
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  public ImmutableList<String> getValues() {
    return values;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CustomTypeMeta#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCustomTypeMeta withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCustomTypeMeta(newValue, this.comment, this.enumEquivalence, this.values);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CustomTypeMeta#getComment() comment} attribute.
   * @param value The value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomTypeMeta withComment(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "comment");
    if (Objects.equals(this.comment, newValue)) return this;
    return new ImmutableCustomTypeMeta(this.name, newValue, this.enumEquivalence, this.values);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CustomTypeMeta#getComment() comment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomTypeMeta withComment(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableCustomTypeMeta(this.name, value, this.enumEquivalence, this.values);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CustomTypeMeta#getEnumEquivalence() enumEquivalence} attribute.
   * @param value The value for enumEquivalence
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomTypeMeta withEnumEquivalence(Class<? extends Enum> value) {
    @Nullable Class<? extends Enum> newValue = Objects.requireNonNull(value, "enumEquivalence");
    if (this.enumEquivalence == newValue) return this;
    return new ImmutableCustomTypeMeta(this.name, this.comment, newValue, this.values);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CustomTypeMeta#getEnumEquivalence() enumEquivalence} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enumEquivalence
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCustomTypeMeta withEnumEquivalence(Optional<? extends Class<? extends Enum>> optional) {
    @Nullable Class<? extends Enum> value = optional.orElse(null);
    if (this.enumEquivalence == value) return this;
    return new ImmutableCustomTypeMeta(this.name, this.comment, value, this.values);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CustomTypeMeta#getValues() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomTypeMeta withValues(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCustomTypeMeta(this.name, this.comment, this.enumEquivalence, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CustomTypeMeta#getValues() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomTypeMeta withValues(Iterable<String> elements) {
    if (this.values == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCustomTypeMeta(this.name, this.comment, this.enumEquivalence, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCustomTypeMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCustomTypeMeta
        && equalTo((ImmutableCustomTypeMeta) another);
  }

  private boolean equalTo(ImmutableCustomTypeMeta another) {
    return name.equals(another.name)
        && Objects.equals(comment, another.comment)
        && Objects.equals(enumEquivalence, another.enumEquivalence)
        && values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code comment}, {@code enumEquivalence}, {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + Objects.hashCode(enumEquivalence);
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CustomTypeMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CustomTypeMeta")
        .omitNullValues()
        .add("name", name)
        .add("comment", comment)
        .add("enumEquivalence", enumEquivalence)
        .add("values", values)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CustomTypeMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CustomTypeMeta instance
   */
  public static ImmutableCustomTypeMeta copyOf(CustomTypeMeta instance) {
    if (instance instanceof ImmutableCustomTypeMeta) {
      return (ImmutableCustomTypeMeta) instance;
    }
    return ImmutableCustomTypeMeta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCustomTypeMeta ImmutableCustomTypeMeta}.
   * <pre>
   * ImmutableCustomTypeMeta.builder()
   *    .name(String) // required {@link CustomTypeMeta#getName() name}
   *    .comment(String) // optional {@link CustomTypeMeta#getComment() comment}
   *    .enumEquivalence(Class&amp;lt;? extends Enum&amp;gt;) // optional {@link CustomTypeMeta#getEnumEquivalence() enumEquivalence}
   *    .addValues|addAllValues(String) // {@link CustomTypeMeta#getValues() values} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCustomTypeMeta builder
   */
  public static ImmutableCustomTypeMeta.Builder builder() {
    return new ImmutableCustomTypeMeta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCustomTypeMeta ImmutableCustomTypeMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CustomTypeMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String comment;
    private @Nullable Class<? extends Enum> enumEquivalence;
    private ImmutableList.Builder<String> values = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CustomTypeMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CustomTypeMeta instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      Optional<String> commentOptional = instance.getComment();
      if (commentOptional.isPresent()) {
        comment(commentOptional);
      }
      Optional<Class<? extends Enum>> enumEquivalenceOptional = instance.getEnumEquivalence();
      if (enumEquivalenceOptional.isPresent()) {
        enumEquivalence(enumEquivalenceOptional);
      }
      addAllValues(instance.getValues());
      return this;
    }

    /**
     * Initializes the value for the {@link CustomTypeMeta#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link CustomTypeMeta#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      return this;
    }

    /**
     * Initializes the optional value {@link CustomTypeMeta#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(Optional<String> comment) {
      this.comment = comment.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CustomTypeMeta#getEnumEquivalence() enumEquivalence} to enumEquivalence.
     * @param enumEquivalence The value for enumEquivalence
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enumEquivalence(Class<? extends Enum> enumEquivalence) {
      this.enumEquivalence = Objects.requireNonNull(enumEquivalence, "enumEquivalence");
      return this;
    }

    /**
     * Initializes the optional value {@link CustomTypeMeta#getEnumEquivalence() enumEquivalence} to enumEquivalence.
     * @param enumEquivalence The value for enumEquivalence
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enumEquivalence(Optional<? extends Class<? extends Enum>> enumEquivalence) {
      this.enumEquivalence = enumEquivalence.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link CustomTypeMeta#getValues() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(String element) {
      this.values.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CustomTypeMeta#getValues() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(String... elements) {
      this.values.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CustomTypeMeta#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder values(Iterable<String> elements) {
      this.values = ImmutableList.builder();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link CustomTypeMeta#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValues(Iterable<String> elements) {
      this.values.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCustomTypeMeta ImmutableCustomTypeMeta}.
     * @return An immutable instance of CustomTypeMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCustomTypeMeta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCustomTypeMeta(name, comment, enumEquivalence, values.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CustomTypeMeta, some of required attributes are not set " + attributes;
    }
  }
}
