package org.nuiton.db.meta;

/*-
 * #%L
 * Nuiton DB Meta
 * %%
 * Copyright (C) 2019 - 2021 Nuiton
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ColumnMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumnMeta.builder()}.
 */
@Generated(from = "ColumnMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableColumnMeta implements ColumnMeta {
  private final String name;
  private final String type;
  private final @Nullable CustomTypeMeta customType;
  private final @Nullable Integer length;
  private final boolean nullable;
  private final @Nullable String comment;
  private final boolean isPrimaryKey;
  private final boolean isUnique;
  private final boolean isForeignKey;
  private final ImmutableSet<String> foreignKeyColumns;
  private final @Nullable Map<String, String> possibleValues;

  private ImmutableColumnMeta(
      String name,
      String type,
      @Nullable CustomTypeMeta customType,
      @Nullable Integer length,
      boolean nullable,
      @Nullable String comment,
      boolean isPrimaryKey,
      boolean isUnique,
      boolean isForeignKey,
      ImmutableSet<String> foreignKeyColumns,
      @Nullable Map<String, String> possibleValues) {
    this.name = name;
    this.type = type;
    this.customType = customType;
    this.length = length;
    this.nullable = nullable;
    this.comment = comment;
    this.isPrimaryKey = isPrimaryKey;
    this.isUnique = isUnique;
    this.isForeignKey = isForeignKey;
    this.foreignKeyColumns = foreignKeyColumns;
    this.possibleValues = possibleValues;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code customType} attribute
   */
  @Override
  public Optional<CustomTypeMeta> getCustomType() {
    return Optional.ofNullable(customType);
  }

  /**
   * @return The value of the {@code length} attribute
   */
  @Override
  public Optional<Integer> getLength() {
    return Optional.ofNullable(length);
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @Override
  public boolean getNullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @Override
  public Optional<String> getComment() {
    return Optional.ofNullable(comment);
  }

  /**
   * @return The value of the {@code isPrimaryKey} attribute
   */
  @Override
  public boolean isPrimaryKey() {
    return isPrimaryKey;
  }

  /**
   * @return The value of the {@code isUnique} attribute
   */
  @Override
  public boolean isUnique() {
    return isUnique;
  }

  /**
   * @return The value of the {@code isForeignKey} attribute
   */
  @Override
  public boolean isForeignKey() {
    return isForeignKey;
  }

  /**
   * @return The value of the {@code foreignKeyColumns} attribute
   */
  @Override
  public ImmutableSet<String> getForeignKeyColumns() {
    return foreignKeyColumns;
  }

  /**
   * @return The value of the {@code possibleValues} attribute
   */
  @Override
  public Optional<Map<String, String>> getPossibleValues() {
    return Optional.ofNullable(possibleValues);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMeta#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMeta withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableColumnMeta(
        newValue,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMeta#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMeta withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableColumnMeta(
        this.name,
        newValue,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ColumnMeta#getCustomType() customType} attribute.
   * @param value The value for customType
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnMeta withCustomType(CustomTypeMeta value) {
    @Nullable CustomTypeMeta newValue = Objects.requireNonNull(value, "customType");
    if (this.customType == newValue) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        newValue,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ColumnMeta#getCustomType() customType} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for customType
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableColumnMeta withCustomType(Optional<? extends CustomTypeMeta> optional) {
    @Nullable CustomTypeMeta value = optional.orElse(null);
    if (this.customType == value) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        value,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ColumnMeta#getLength() length} attribute.
   * @param value The value for length
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnMeta withLength(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.length, newValue)) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        newValue,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ColumnMeta#getLength() length} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for length
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnMeta withLength(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.length, value)) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        value,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMeta#getNullable() nullable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMeta withNullable(boolean value) {
    if (this.nullable == value) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        value,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ColumnMeta#getComment() comment} attribute.
   * @param value The value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnMeta withComment(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "comment");
    if (Objects.equals(this.comment, newValue)) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        newValue,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ColumnMeta#getComment() comment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnMeta withComment(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        value,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMeta#isPrimaryKey() isPrimaryKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPrimaryKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMeta withIsPrimaryKey(boolean value) {
    if (this.isPrimaryKey == value) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        value,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMeta#isUnique() isUnique} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isUnique
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMeta withIsUnique(boolean value) {
    if (this.isUnique == value) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        value,
        this.isForeignKey,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMeta#isForeignKey() isForeignKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isForeignKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMeta withIsForeignKey(boolean value) {
    if (this.isForeignKey == value) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        value,
        this.foreignKeyColumns,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ColumnMeta#getForeignKeyColumns() foreignKeyColumns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnMeta withForeignKeyColumns(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        newValue,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ColumnMeta#getForeignKeyColumns() foreignKeyColumns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of foreignKeyColumns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnMeta withForeignKeyColumns(Iterable<String> elements) {
    if (this.foreignKeyColumns == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        newValue,
        this.possibleValues);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ColumnMeta#getPossibleValues() possibleValues} attribute.
   * @param value The value for possibleValues
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnMeta withPossibleValues(Map<String, String> value) {
    @Nullable Map<String, String> newValue = Objects.requireNonNull(value, "possibleValues");
    if (this.possibleValues == newValue) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ColumnMeta#getPossibleValues() possibleValues} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for possibleValues
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableColumnMeta withPossibleValues(Optional<? extends Map<String, String>> optional) {
    @Nullable Map<String, String> value = optional.orElse(null);
    if (this.possibleValues == value) return this;
    return new ImmutableColumnMeta(
        this.name,
        this.type,
        this.customType,
        this.length,
        this.nullable,
        this.comment,
        this.isPrimaryKey,
        this.isUnique,
        this.isForeignKey,
        this.foreignKeyColumns,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumnMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumnMeta
        && equalTo((ImmutableColumnMeta) another);
  }

  private boolean equalTo(ImmutableColumnMeta another) {
    return name.equals(another.name)
        && type.equals(another.type)
        && Objects.equals(customType, another.customType)
        && Objects.equals(length, another.length)
        && nullable == another.nullable
        && Objects.equals(comment, another.comment)
        && isPrimaryKey == another.isPrimaryKey
        && isUnique == another.isUnique
        && isForeignKey == another.isForeignKey
        && foreignKeyColumns.equals(another.foreignKeyColumns)
        && Objects.equals(possibleValues, another.possibleValues);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}, {@code customType}, {@code length}, {@code nullable}, {@code comment}, {@code isPrimaryKey}, {@code isUnique}, {@code isForeignKey}, {@code foreignKeyColumns}, {@code possibleValues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(customType);
    h += (h << 5) + Objects.hashCode(length);
    h += (h << 5) + Booleans.hashCode(nullable);
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + Booleans.hashCode(isPrimaryKey);
    h += (h << 5) + Booleans.hashCode(isUnique);
    h += (h << 5) + Booleans.hashCode(isForeignKey);
    h += (h << 5) + foreignKeyColumns.hashCode();
    h += (h << 5) + Objects.hashCode(possibleValues);
    return h;
  }

  /**
   * Prints the immutable value {@code ColumnMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ColumnMeta")
        .omitNullValues()
        .add("name", name)
        .add("type", type)
        .add("customType", customType)
        .add("length", length)
        .add("nullable", nullable)
        .add("comment", comment)
        .add("isPrimaryKey", isPrimaryKey)
        .add("isUnique", isUnique)
        .add("isForeignKey", isForeignKey)
        .add("foreignKeyColumns", foreignKeyColumns)
        .add("possibleValues", possibleValues)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ColumnMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ColumnMeta instance
   */
  public static ImmutableColumnMeta copyOf(ColumnMeta instance) {
    if (instance instanceof ImmutableColumnMeta) {
      return (ImmutableColumnMeta) instance;
    }
    return ImmutableColumnMeta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumnMeta ImmutableColumnMeta}.
   * <pre>
   * ImmutableColumnMeta.builder()
   *    .name(String) // required {@link ColumnMeta#getName() name}
   *    .type(String) // required {@link ColumnMeta#getType() type}
   *    .customType(org.nuiton.db.meta.CustomTypeMeta) // optional {@link ColumnMeta#getCustomType() customType}
   *    .length(Integer) // optional {@link ColumnMeta#getLength() length}
   *    .nullable(boolean) // required {@link ColumnMeta#getNullable() nullable}
   *    .comment(String) // optional {@link ColumnMeta#getComment() comment}
   *    .isPrimaryKey(boolean) // required {@link ColumnMeta#isPrimaryKey() isPrimaryKey}
   *    .isUnique(boolean) // required {@link ColumnMeta#isUnique() isUnique}
   *    .isForeignKey(boolean) // required {@link ColumnMeta#isForeignKey() isForeignKey}
   *    .addForeignKeyColumns|addAllForeignKeyColumns(String) // {@link ColumnMeta#getForeignKeyColumns() foreignKeyColumns} elements
   *    .possibleValues(Map&amp;lt;String, String&amp;gt;) // optional {@link ColumnMeta#getPossibleValues() possibleValues}
   *    .build();
   * </pre>
   * @return A new ImmutableColumnMeta builder
   */
  public static ImmutableColumnMeta.Builder builder() {
    return new ImmutableColumnMeta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumnMeta ImmutableColumnMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ColumnMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_NULLABLE = 0x4L;
    private static final long INIT_BIT_IS_PRIMARY_KEY = 0x8L;
    private static final long INIT_BIT_IS_UNIQUE = 0x10L;
    private static final long INIT_BIT_IS_FOREIGN_KEY = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String name;
    private @Nullable String type;
    private @Nullable CustomTypeMeta customType;
    private @Nullable Integer length;
    private boolean nullable;
    private @Nullable String comment;
    private boolean isPrimaryKey;
    private boolean isUnique;
    private boolean isForeignKey;
    private ImmutableSet.Builder<String> foreignKeyColumns = ImmutableSet.builder();
    private @Nullable Map<String, String> possibleValues;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ColumnMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ColumnMeta instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      type(instance.getType());
      Optional<CustomTypeMeta> customTypeOptional = instance.getCustomType();
      if (customTypeOptional.isPresent()) {
        customType(customTypeOptional);
      }
      Optional<Integer> lengthOptional = instance.getLength();
      if (lengthOptional.isPresent()) {
        length(lengthOptional);
      }
      nullable(instance.getNullable());
      Optional<String> commentOptional = instance.getComment();
      if (commentOptional.isPresent()) {
        comment(commentOptional);
      }
      isPrimaryKey(instance.isPrimaryKey());
      isUnique(instance.isUnique());
      isForeignKey(instance.isForeignKey());
      addAllForeignKeyColumns(instance.getForeignKeyColumns());
      Optional<Map<String, String>> possibleValuesOptional = instance.getPossibleValues();
      if (possibleValuesOptional.isPresent()) {
        possibleValues(possibleValuesOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMeta#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMeta#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnMeta#getCustomType() customType} to customType.
     * @param customType The value for customType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customType(CustomTypeMeta customType) {
      this.customType = Objects.requireNonNull(customType, "customType");
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnMeta#getCustomType() customType} to customType.
     * @param customType The value for customType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customType(Optional<? extends CustomTypeMeta> customType) {
      this.customType = customType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnMeta#getLength() length} to length.
     * @param length The value for length
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder length(int length) {
      this.length = length;
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnMeta#getLength() length} to length.
     * @param length The value for length
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder length(Optional<Integer> length) {
      this.length = length.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMeta#getNullable() nullable} attribute.
     * @param nullable The value for nullable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nullable(boolean nullable) {
      this.nullable = nullable;
      initBits &= ~INIT_BIT_NULLABLE;
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnMeta#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnMeta#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(Optional<String> comment) {
      this.comment = comment.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMeta#isPrimaryKey() isPrimaryKey} attribute.
     * @param isPrimaryKey The value for isPrimaryKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPrimaryKey(boolean isPrimaryKey) {
      this.isPrimaryKey = isPrimaryKey;
      initBits &= ~INIT_BIT_IS_PRIMARY_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMeta#isUnique() isUnique} attribute.
     * @param isUnique The value for isUnique 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isUnique(boolean isUnique) {
      this.isUnique = isUnique;
      initBits &= ~INIT_BIT_IS_UNIQUE;
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMeta#isForeignKey() isForeignKey} attribute.
     * @param isForeignKey The value for isForeignKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isForeignKey(boolean isForeignKey) {
      this.isForeignKey = isForeignKey;
      initBits &= ~INIT_BIT_IS_FOREIGN_KEY;
      return this;
    }

    /**
     * Adds one element to {@link ColumnMeta#getForeignKeyColumns() foreignKeyColumns} set.
     * @param element A foreignKeyColumns element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addForeignKeyColumns(String element) {
      this.foreignKeyColumns.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ColumnMeta#getForeignKeyColumns() foreignKeyColumns} set.
     * @param elements An array of foreignKeyColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addForeignKeyColumns(String... elements) {
      this.foreignKeyColumns.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ColumnMeta#getForeignKeyColumns() foreignKeyColumns} set.
     * @param elements An iterable of foreignKeyColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder foreignKeyColumns(Iterable<String> elements) {
      this.foreignKeyColumns = ImmutableSet.builder();
      return addAllForeignKeyColumns(elements);
    }

    /**
     * Adds elements to {@link ColumnMeta#getForeignKeyColumns() foreignKeyColumns} set.
     * @param elements An iterable of foreignKeyColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllForeignKeyColumns(Iterable<String> elements) {
      this.foreignKeyColumns.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnMeta#getPossibleValues() possibleValues} to possibleValues.
     * @param possibleValues The value for possibleValues
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder possibleValues(Map<String, String> possibleValues) {
      this.possibleValues = Objects.requireNonNull(possibleValues, "possibleValues");
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnMeta#getPossibleValues() possibleValues} to possibleValues.
     * @param possibleValues The value for possibleValues
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder possibleValues(Optional<? extends Map<String, String>> possibleValues) {
      this.possibleValues = possibleValues.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumnMeta ImmutableColumnMeta}.
     * @return An immutable instance of ColumnMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumnMeta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumnMeta(
          name,
          type,
          customType,
          length,
          nullable,
          comment,
          isPrimaryKey,
          isUnique,
          isForeignKey,
          foreignKeyColumns.build(),
          possibleValues);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NULLABLE) != 0) attributes.add("nullable");
      if ((initBits & INIT_BIT_IS_PRIMARY_KEY) != 0) attributes.add("isPrimaryKey");
      if ((initBits & INIT_BIT_IS_UNIQUE) != 0) attributes.add("isUnique");
      if ((initBits & INIT_BIT_IS_FOREIGN_KEY) != 0) attributes.add("isForeignKey");
      return "Cannot build ColumnMeta, some of required attributes are not set " + attributes;
    }
  }
}
